/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csutils.groovy;

import com.centrasite.jaxr.infomodel.CentraSiteRegistryObject;
import groovy.lang.DelegatingMetaClass;
import groovy.lang.MetaClass;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.RegistryEntry;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Slot;
import net.sf.csutils.core.model.QName;
import net.sf.csutils.core.model.ROAttribute;
import net.sf.csutils.core.model.ROClassification;
import net.sf.csutils.core.model.ROMetaModel;
import net.sf.csutils.core.model.RORelation;
import net.sf.csutils.core.model.ROType;
import net.sf.csutils.core.utils.Generics;
import net.sf.csutils.core.utils.RegistryObjects;
import net.sf.csutils.groovy.GroovyObjects;
import org.apache.ws.commons.util.XsDateFormat;
import org.apache.ws.commons.util.XsDateTimeFormat;
import org.apache.ws.commons.util.XsTimeFormat;
import org.codehaus.groovy.runtime.InvokerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegistryObjectMetaClass
extends DelegatingMetaClass {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final XsDateTimeFormat dateTimeFormat = new XsDateTimeFormat();
    private static final XsDateFormat dateFormat = new XsDateFormat();
    private static final XsTimeFormat timeFormat = new XsTimeFormat();

    protected abstract ROMetaModel getMetaModel();

    public RegistryObjectMetaClass(MetaClass delegate) {
        super(delegate);
    }

    private ROType getType(RegistryObject pRegistryObject) throws JAXRException {
        QName qName = QName.valueOf((String)pRegistryObject.getObjectType().getValue());
        ROType type = this.getMetaModel().getROType(qName);
        if (type == null) {
            throw new IllegalArgumentException("Unknown registry object type: " + qName);
        }
        return type;
    }

    public void setProperty(Object pObject, String pProperty, Object pValues) {
        try {
            RegistryObject ro = (RegistryObject)pObject;
            ROAttribute attr = this.getType(ro).getAttribute(pProperty);
            if (attr == null) {
                this.setStringSlot(ro, pProperty, pValues);
            } else {
                switch (attr.getType()) {
                    case bool: {
                        this.setBooleanSlot(ro, pProperty, pValues);
                        break;
                    }
                    case date: {
                        this.setDateSlot(ro, pProperty, pValues);
                        break;
                    }
                    case dateTime: {
                        this.setDateTimeSlot(ro, pProperty, pValues);
                        break;
                    }
                    case duration: {
                        this.setDurationSlot(ro, pProperty, pValues);
                        break;
                    }
                    case emailAddress: {
                        this.setStringSlot(ro, pProperty, pValues, "CS:emailAddress_type");
                        break;
                    }
                    case integer: {
                        this.setIntegerSlot(ro, pProperty, pValues);
                        break;
                    }
                    case ipv4Address: {
                        this.setStringSlot(ro, pProperty, pValues, "CS:ipv4_type");
                        break;
                    }
                    case ipv6Address: {
                        this.setStringSlot(ro, pProperty, pValues, "CS:ipv6_type");
                        break;
                    }
                    case longInteger: {
                        this.setLongSlot(ro, pProperty, pValues);
                        break;
                    }
                    case number: {
                        this.setNumberSlot(ro, pProperty, pValues);
                        break;
                    }
                    case relation: {
                        this.setRelationSlot((RORelation)attr, ro, pProperty, pValues);
                        break;
                    }
                    case string: 
                    case uri: {
                        this.setStringSlot(ro, pProperty, pValues);
                        break;
                    }
                    case time: {
                        this.setTimeSlot(ro, pProperty, pValues);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid slot type: " + attr.getType());
                    }
                }
            }
        }
        catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private void setStringSlot(RegistryObject pObject, String pProperty, Object pValues) throws JAXRException {
        this.setStringSlot(pObject, pProperty, pValues, "xs:string");
    }

    private void setStringSlot(RegistryObject pObject, String pProperty, Object pValues, String pType) throws JAXRException {
        List objectList = InvokerHelper.asList((Object)pValues);
        ArrayList<String> stringList = new ArrayList<String>(objectList.size());
        for (Object o : objectList) {
            stringList.add(String.valueOf(o));
        }
        this.setSlot(pProperty, pObject, stringList, pType);
    }

    private void setBooleanSlot(RegistryObject pObject, String pProperty, Object pValues) throws JAXRException {
        List objectList = InvokerHelper.asList((Object)pValues);
        ArrayList<String> stringList = new ArrayList<String>(objectList.size());
        for (Object o : objectList) {
            String s = o == null ? Boolean.FALSE.toString() : (o instanceof Boolean ? o.toString() : String.valueOf(Boolean.parseBoolean(o.toString())));
            stringList.add(s);
        }
        this.setSlot(pProperty, pObject, stringList, "xs:boolean");
    }

    private void setIntegerSlot(RegistryObject pObject, String pProperty, Object pValues) throws JAXRException {
        List objectList = InvokerHelper.asList((Object)pValues);
        ArrayList<String> stringList = new ArrayList<String>(objectList.size());
        for (Object o : objectList) {
            String s;
            if (o == null) {
                s = "0";
            } else if (o instanceof Number) {
                s = String.valueOf(((Number)o).intValue());
            } else {
                try {
                    s = String.valueOf(Integer.parseInt(String.valueOf(o)));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid integer value for slot " + pProperty + ": " + o);
                }
            }
            stringList.add(s);
        }
        this.setSlot(pProperty, pObject, stringList, "xs:int");
    }

    private void setNumberSlot(RegistryObject pObject, String pProperty, Object pValues) throws JAXRException {
        List objectList = InvokerHelper.asList((Object)pValues);
        ArrayList<String> stringList = new ArrayList<String>(objectList.size());
        for (Object o : objectList) {
            String s;
            if (o == null) {
                s = "0";
            } else if (o instanceof Number) {
                s = String.valueOf(((Number)o).doubleValue());
            } else {
                try {
                    s = String.valueOf(Double.parseDouble(String.valueOf(o)));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid number value for slot " + pProperty + ": " + o);
                }
            }
            stringList.add(s);
        }
        this.setSlot(pProperty, pObject, stringList, "xs:double");
    }

    private void setLongSlot(RegistryObject pObject, String pProperty, Object pValues) throws JAXRException {
        List objectList = InvokerHelper.asList((Object)pValues);
        ArrayList<String> stringList = new ArrayList<String>(objectList.size());
        for (Object o : objectList) {
            String s;
            if (o == null) {
                s = "0";
            } else if (o instanceof Number) {
                s = String.valueOf(((Number)o).longValue());
            } else {
                try {
                    s = String.valueOf(Long.parseLong(String.valueOf(o)));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid long value for slot " + pProperty + ": " + o);
                }
            }
            stringList.add(s);
        }
        this.setSlot(pProperty, pObject, stringList, "xs:long");
    }

    private void setDateSlot(RegistryObject pObject, String pProperty, Object pValues) throws JAXRException {
        this.setDateTimeSlot(pObject, pProperty, pValues, (Format)dateFormat, "xs:date");
    }

    private void setDateTimeSlot(RegistryObject pObject, String pProperty, Object pValues) throws JAXRException {
        this.setDateTimeSlot(pObject, pProperty, pValues, (Format)dateTimeFormat, "xs:dateTime");
    }

    private void setTimeSlot(RegistryObject pObject, String pProperty, Object pValues) throws JAXRException {
        this.setDateTimeSlot(pObject, pProperty, pValues, (Format)timeFormat, "xs:time");
    }

    private void setRelationSlot(RORelation pRelation, RegistryObject pObject, String pProperty, Object pValues) throws JAXRException {
        throw new IllegalStateException("Relations not yet supported.");
    }

    private void setDurationSlot(RegistryObject pObject, String pProperty, Object pValues) throws JAXRException {
        throw new IllegalStateException("Durations not implemented.");
    }

    private void setDateTimeSlot(RegistryObject pObject, String pProperty, Object pValues, Format pFormat, String pType) throws JAXRException {
        List objectList = InvokerHelper.asList((Object)pValues);
        ArrayList<String> stringList = new ArrayList<String>(objectList.size());
        for (Object o : objectList) {
            String s;
            Calendar cal;
            if (o == null) {
                cal = Calendar.getInstance(GMT);
                cal.setTimeInMillis(0L);
                s = pFormat.format(cal);
            } else if (o instanceof Calendar) {
                s = pFormat.format(o);
            } else if (o instanceof Date) {
                cal = Calendar.getInstance(GMT);
                cal.setTime((Date)o);
                s = pFormat.format(cal);
            } else {
                try {
                    s = pFormat.format(pFormat.parseObject(o.toString()));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid " + pType + " value for slot " + pProperty + ": " + o);
                }
            }
            stringList.add(s);
        }
        this.setSlot(pProperty, pObject, stringList, pType);
    }

    public Object getProperty(Object pObject, String pProperty) {
        try {
            RegistryObject ro = (RegistryObject)pObject;
            ROAttribute attr = this.getType(ro).getAttribute(pProperty);
            return this.getAttributeValue(ro, attr, pProperty);
        }
        catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (ParseException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private Object getAttributeValue(RegistryObject pObject, ROAttribute pAttr, String pProperty) throws JAXRException, ParseException {
        if (pAttr == null) {
            Slot slot = this.getSlot(pProperty, pObject);
            if (slot == null) {
                return null;
            }
            return this.asStringArray(slot);
        }
        boolean isMultiple = pAttr.getMaxOccurs() == -1 || pAttr.getMaxOccurs() > 1;
        switch (pAttr.getType()) {
            case bool: {
                return isMultiple ? this.asBooleanArray(this.getSlot(pProperty, pObject)) : this.asBoolean(this.getSlot(pProperty, pObject));
            }
            case date: {
                return isMultiple ? this.asDateArray(this.getSlot(pProperty, pObject)) : this.asDate(this.getSlot(pProperty, pObject));
            }
            case dateTime: {
                return isMultiple ? this.asDateTimeArray(this.getSlot(pProperty, pObject)) : this.asDateTime(this.getSlot(pProperty, pObject));
            }
            case time: {
                return isMultiple ? this.asTimeArray(this.getSlot(pProperty, pObject)) : this.asTime(this.getSlot(pProperty, pObject));
            }
            case duration: {
                throw new IllegalStateException("Durations are not yet supported.");
            }
            case emailAddress: 
            case ipv4Address: 
            case ipv6Address: 
            case string: 
            case uri: {
                return isMultiple ? this.asStringArray(this.getSlot(pProperty, pObject)) : this.asString(this.getSlot(pProperty, pObject));
            }
            case integer: {
                return isMultiple ? this.asIntegerArray(this.getSlot(pProperty, pObject)) : this.asInteger(this.getSlot(pProperty, pObject));
            }
            case longInteger: {
                return isMultiple ? this.asLongArray(this.getSlot(pProperty, pObject)) : this.asLong(this.getSlot(pProperty, pObject));
            }
            case number: {
                return isMultiple ? this.asBigDecimalArray(this.getSlot(pProperty, pObject)) : this.asBigDecimal(this.getSlot(pProperty, pObject));
            }
            case relation: {
                return isMultiple ? this.asTargetArray(pObject, (RORelation)pAttr) : this.asTarget(pObject, (RORelation)pAttr);
            }
            case classification: {
                return isMultiple ? this.asClassificationArray(pObject, (ROClassification)pAttr) : this.asClassification(pObject, (ROClassification)pAttr);
            }
        }
        throw new IllegalStateException("Unsupported attribute type: " + pAttr.getType());
    }

    private Slot getSlot(String pProperty, RegistryObject pObject) throws JAXRException {
        return pObject.getSlot(this.getSlotName(pProperty, pObject));
    }

    private void setSlot(String pProperty, RegistryObject pObject, Collection<String> pValues, String pType) throws JAXRException {
        String slotName = this.getSlotName(pProperty, pObject);
        Slot slot = pObject.getSlot(slotName);
        if (slot == null) {
            BusinessLifeCycleManager blcm = ((CentraSiteRegistryObject)pObject).getRegistryService().getBusinessLifeCycleManager();
            pObject.addSlot(blcm.createSlot(slotName, pValues, pType));
        } else {
            slot.setValues(pValues);
            slot.setSlotType(pType);
        }
    }

    private String getSlotName(String pProperty, RegistryObject pObject) throws JAXRException {
        String objectType = pObject.getObjectType().getValue();
        int offset = objectType.indexOf(125);
        String slotName = offset == -1 ? pProperty : objectType.substring(0, offset + 1) + pProperty;
        return slotName;
    }

    private String asString(Slot pSlot) throws JAXRException {
        if (pSlot == null) {
            return null;
        }
        Collection values = pSlot.getValues();
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object o = values.iterator().next();
        return o == null ? null : o.toString();
    }

    private String[] asStringArray(Slot pSlot) throws JAXRException {
        if (pSlot == null) {
            return new String[0];
        }
        Collection values = pSlot.getValues();
        String[] result = new String[values.size()];
        int i = 0;
        for (Object o : values) {
            result[i++] = o == null ? null : o.toString();
        }
        return result;
    }

    private Integer asInteger(Slot pSlot) throws JAXRException {
        if (pSlot == null) {
            return null;
        }
        Collection values = pSlot.getValues();
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object o = values.iterator().next();
        return o == null ? null : Integer.valueOf(o.toString());
    }

    private Integer[] asIntegerArray(Slot pSlot) throws JAXRException {
        if (pSlot == null) {
            return new Integer[0];
        }
        Collection values = pSlot.getValues();
        Integer[] result = new Integer[values.size()];
        int i = 0;
        for (Object o : values) {
            result[i++] = o == null ? null : Integer.valueOf(o.toString());
        }
        return result;
    }

    private BigDecimal asBigDecimal(Slot pSlot) throws JAXRException {
        if (pSlot == null) {
            return null;
        }
        Collection values = pSlot.getValues();
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object o = values.iterator().next();
        return o == null ? null : new BigDecimal(o.toString());
    }

    private BigDecimal[] asBigDecimalArray(Slot pSlot) throws JAXRException {
        if (pSlot == null) {
            return new BigDecimal[0];
        }
        Collection values = pSlot.getValues();
        BigDecimal[] result = new BigDecimal[values.size()];
        int i = 0;
        for (Object o : values) {
            result[i++] = o == null ? null : new BigDecimal(o.toString());
        }
        return result;
    }

    private Long asLong(Slot pSlot) throws JAXRException {
        if (pSlot == null) {
            return null;
        }
        Collection values = pSlot.getValues();
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object o = values.iterator().next();
        return o == null ? null : Long.valueOf(o.toString());
    }

    private Long[] asLongArray(Slot pSlot) throws JAXRException {
        if (pSlot == null) {
            return new Long[0];
        }
        Collection values = pSlot.getValues();
        Long[] result = new Long[values.size()];
        int i = 0;
        for (Object o : values) {
            result[i++] = o == null ? null : Long.valueOf(o.toString());
        }
        return result;
    }

    private Boolean asBoolean(Slot pSlot) throws JAXRException {
        if (pSlot == null) {
            return null;
        }
        Collection values = pSlot.getValues();
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object o = values.iterator().next();
        return o == null ? null : Boolean.valueOf(o.toString());
    }

    private Boolean[] asBooleanArray(Slot pSlot) throws JAXRException {
        if (pSlot == null) {
            return new Boolean[0];
        }
        Collection values = pSlot.getValues();
        Boolean[] result = new Boolean[values.size()];
        int i = 0;
        for (Object o : values) {
            result[i++] = o == null ? null : Boolean.valueOf(o.toString());
        }
        return result;
    }

    private Concept asClassification(RegistryObject pObject, ROClassification pAttr) throws JAXRException {
        List<Concept> list = this.asClassificationList(pObject, pAttr);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    private Concept[] asClassificationArray(RegistryObject pObject, ROClassification pAttr) throws JAXRException {
        List<Concept> list = this.asClassificationList(pObject, pAttr);
        return list.toArray(new Concept[list.size()]);
    }

    private List<Concept> asClassificationList(RegistryObject pObject, ROClassification pAttr) throws JAXRException {
        Collection cls = (Collection)Generics.cast((Object)pObject.getClassifications());
        ArrayList<Concept> list = new ArrayList<Concept>();
        for (Classification cl : cls) {
            Iterator iter;
            Collection values;
            Slot slot = cl.getSlot("{http://namespaces.CentraSite.com/Schema}attributeKey");
            if (slot == null || (values = slot.getValues()) == null || !(iter = values.iterator()).hasNext() || !iter.next().equals(pAttr.getAttributeKey())) continue;
            list.add(cl.getConcept());
        }
        return list;
    }

    private RegistryObject asTarget(RegistryObject pObject, RORelation pAttr) throws JAXRException {
        List<RegistryObject> list = this.asTargetList(pObject, pAttr);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    private RegistryObject[] asTargetArray(RegistryObject pObject, RORelation pAttr) throws JAXRException {
        List<RegistryObject> list = this.asTargetList(pObject, pAttr);
        return list.toArray(new RegistryObject[list.size()]);
    }

    private List<RegistryObject> asTargetList(RegistryObject pObject, RORelation pAttr) throws JAXRException {
        Collection assocs = (Collection)Generics.cast((Object)pObject.getAssociations());
        ArrayList<RegistryObject> list = new ArrayList<RegistryObject>();
        for (Association assoc : assocs) {
            Iterator iter;
            Collection values;
            Slot slot = assoc.getSlot("{http://namespaces.CentraSite.com/Schema}attributeKey");
            if (slot == null || (values = slot.getValues()) == null || !(iter = values.iterator()).hasNext() || !iter.next().equals(pAttr.getAttributeKey())) continue;
            list.add(assoc.getTargetObject());
        }
        return list;
    }

    private Calendar asDate(Slot pSlot) throws JAXRException, ParseException {
        return this.asCalendar(pSlot, (Format)dateFormat);
    }

    private Calendar[] asDateArray(Slot pSlot) throws JAXRException, ParseException {
        return this.asCalendarArray(pSlot, (Format)dateFormat);
    }

    private Calendar asDateTime(Slot pSlot) throws JAXRException, ParseException {
        return this.asCalendar(pSlot, (Format)dateTimeFormat);
    }

    private Calendar[] asDateTimeArray(Slot pSlot) throws JAXRException, ParseException {
        return this.asCalendarArray(pSlot, (Format)dateTimeFormat);
    }

    private Calendar asTime(Slot pSlot) throws JAXRException, ParseException {
        return this.asCalendar(pSlot, (Format)timeFormat);
    }

    private Calendar[] asTimeArray(Slot pSlot) throws JAXRException, ParseException {
        return this.asCalendarArray(pSlot, (Format)timeFormat);
    }

    private Calendar asCalendar(Slot pSlot, Format pFormat) throws JAXRException, ParseException {
        if (pSlot == null) {
            return null;
        }
        Collection values = pSlot.getValues();
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object o = values.iterator().next();
        return o == null ? null : (Calendar)pFormat.parseObject(o.toString());
    }

    private Calendar[] asCalendarArray(Slot pSlot, Format pFormat) throws JAXRException, ParseException {
        if (pSlot == null) {
            return new Calendar[0];
        }
        Collection values = pSlot.getValues();
        Calendar[] result = new Calendar[values.size()];
        int i = 0;
        for (Object o : values) {
            result[i++] = o == null ? null : (Calendar)pFormat.parseObject(o.toString());
        }
        return result;
    }

    private String getKey(RegistryObject ro) throws JAXRException {
        return ro.getKey().getId();
    }

    private String getName(RegistryObject ro, Locale pLocale) throws JAXRException {
        return pLocale == null ? RegistryObjects.getName((RegistryObject)ro) : RegistryObjects.getName((RegistryObject)ro, (Locale)pLocale);
    }

    private InternationalString getNames(RegistryObject ro) throws JAXRException {
        return ro.getName();
    }

    private String getDescription(RegistryObject ro, Locale pLocale) throws JAXRException {
        return pLocale == null ? RegistryObjects.getDescription((RegistryObject)ro) : RegistryObjects.getDescription((RegistryObject)ro, (Locale)pLocale);
    }

    private InternationalString getDescriptions(RegistryObject ro) throws JAXRException {
        return ro.getDescription();
    }

    private Integer getStatus(RegistryObject ro) throws JAXRException {
        return ro instanceof RegistryEntry ? Integer.valueOf(((RegistryEntry)ro).getStatus()) : null;
    }

    private String getStatusName(RegistryObject ro) throws JAXRException {
        if (ro instanceof RegistryEntry) {
            int status = ((RegistryEntry)ro).getStatus();
            switch (status) {
                case 1: {
                    return "APPROVED";
                }
                case 2: {
                    return "DEPRECATED";
                }
                case 0: {
                    return "SUBMITTED";
                }
                case 3: {
                    return "WITHDRAWN";
                }
            }
            return String.valueOf(status);
        }
        return null;
    }

    private Integer getStability(RegistryObject ro) throws JAXRException {
        return ro instanceof RegistryEntry ? Integer.valueOf(((RegistryEntry)ro).getStability()) : null;
    }

    private String getStabilityName(RegistryObject ro) throws JAXRException {
        if (ro instanceof RegistryEntry) {
            int stability = ((RegistryEntry)ro).getStability();
            switch (stability) {
                case 0: {
                    return "DYNAMIC";
                }
                case 1: {
                    return "DYNAMIC_COMPATIBLE";
                }
                case 2: {
                    return "STATIC";
                }
            }
            return String.valueOf(stability);
        }
        return null;
    }

    private Integer getMajorVersion(RegistryObject ro) throws JAXRException {
        return ro instanceof RegistryEntry ? Integer.valueOf(((RegistryEntry)ro).getMajorVersion()) : null;
    }

    private Integer getMinorVersion(RegistryObject ro) throws JAXRException {
        return ro instanceof RegistryEntry ? Integer.valueOf(((RegistryEntry)ro).getMinorVersion()) : null;
    }

    private String getUserVersion(RegistryObject ro) throws JAXRException {
        return ro instanceof RegistryEntry ? ((RegistryEntry)ro).getUserVersion() : null;
    }

    public Object invokeMethod(Object pObject, String pMethodName, Object[] pArgs) {
        RegistryObject ro = (RegistryObject)pObject;
        try {
            if (pMethodName.equals("attribute")) {
                String propertyName = GroovyObjects.checkStringArg(pMethodName, pArgs);
                return this.getProperty(pObject, propertyName);
            }
            if (pMethodName.equals("key")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return this.getKey(ro);
            }
            if (pMethodName.equals("name")) {
                return this.getName(ro, GroovyObjects.getLocaleArg(pMethodName, pArgs));
            }
            if (pMethodName.equals("names")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return this.getNames(ro);
            }
            if (pMethodName.equals("description")) {
                return this.getDescription(ro, GroovyObjects.getLocaleArg(pMethodName, pArgs));
            }
            if (pMethodName.equals("descriptions")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return this.getDescriptions(ro);
            }
            if (pMethodName.equals("status")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return this.getStatusName(ro);
            }
            if (pMethodName.equals("statusInt")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return this.getStatus(ro);
            }
            if (pMethodName.equals("stability")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return this.getStabilityName(ro);
            }
            if (pMethodName.equals("stabilityInt")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return this.getStability(ro);
            }
            if (pMethodName.equals("minorVersion")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return this.getMinorVersion(ro);
            }
            if (pMethodName.equals("majorVersion")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return this.getMajorVersion(ro);
            }
            if (pMethodName.equals("userVersion")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return this.getUserVersion(ro);
            }
            if (pMethodName.equals("objectType")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return ro.getObjectType();
            }
            if (pMethodName.equals("value")) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return ro instanceof Concept ? ((Concept)ro).getValue() : null;
            }
            return super.invokeMethod(pObject, pMethodName, pArgs);
        }
        catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

