/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csutils.groovy.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import net.sf.csutils.groovy.xml.XmlTemplateEngine;
import net.sf.csutils.groovy.xml.XmlTemplateEngineStreamReader;
import net.sf.csutils.groovy.xml.XmlTemplateEngineStreamWriter;
import org.xml.sax.helpers.AttributesImpl;

public class XmlTemplateEngineParser {
    private static final QName ATTR_NAME = new QName("http://namespaces.csutils.sf.net/groovy/xml/XmlTemplateEngine", "name");
    private static final QName ATTR_SIMPLE_NAME = new QName("name");
    private static final QName ATTR_SIMPLE_VALUE = new QName("value");
    private final XmlTemplateEngineStreamReader xsr;
    private final Writer writer;

    public XmlTemplateEngineParser(Reader pReader, Writer pWriter) throws XMLStreamException {
        this.writer = pWriter;
        this.xsr = new XmlTemplateEngineStreamReader(pReader);
    }

    private void write(String pValue) throws IOException {
        this.writer.write(pValue);
    }

    private void writeEscaped(String pValue) throws IOException {
        this.writer.write(34);
        block7: for (int i = 0; i < pValue.length(); ++i) {
            char c = pValue.charAt(i);
            switch (c) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block7;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block7;
                }
                case '\n': {
                    this.writer.write("\\n");
                    continue block7;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block7;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block7;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
        this.writer.write(34);
    }

    private void createHeader() throws IOException {
        this.write("/* Generated by ");
        this.write(XmlTemplateEngine.class.getName());
        this.write(" */\n");
        this.write("import ");
        this.write(AttributesImpl.class.getName());
        this.write("\ndef xsw = new ");
        this.write(XmlTemplateEngineStreamWriter.class.getName());
        this.write("(out)\n");
        this.write("def attrs = null\n");
        this.write("def buffer = null\n");
        this.write("def qName = null\n");
    }

    private void createFooter() throws IOException {
    }

    public void parse() throws XMLStreamException, IOException {
        this.createHeader();
        this.parseElement();
        this.createFooter();
    }

    private boolean isWhitespace(XmlTemplateEngineStreamReader.TextEvent pEvent) {
        String data = pEvent.getText();
        for (int i = 0; i < data.length(); ++i) {
            if (Character.isWhitespace(data.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isAttributeEvent(XmlTemplateEngineStreamReader.Event pEvent) {
        switch (pEvent.getEventType()) {
            case 5: 
            case 6: {
                return true;
            }
            case 4: 
            case 12: {
                return this.isWhitespace((XmlTemplateEngineStreamReader.TextEvent)pEvent);
            }
            case 1: {
                XmlTemplateEngineStreamReader.StartElementEvent startElementEvent = (XmlTemplateEngineStreamReader.StartElementEvent)pEvent;
                QName qName = startElementEvent.getName();
                return "http://namespaces.csutils.sf.net/groovy/xml/XmlTemplateEngine".equals(qName.getNamespaceURI()) && "scriptlet".equals(qName.getLocalPart());
            }
        }
        return false;
    }

    private void applyAttributeEvent(XmlTemplateEngineStreamReader.Event pEvent) throws XMLStreamException, IOException {
        switch (pEvent.getEventType()) {
            default: {
                throw new XMLStreamException("Invalid event type: " + pEvent.getEventType());
            }
            case 4: 
            case 6: 
            case 12: {
                this.handleCharacters(pEvent.getEventType(), ((XmlTemplateEngineStreamReader.TextEvent)pEvent).getText());
                break;
            }
            case 1: {
                XmlTemplateEngineStreamReader.StartElementEvent startElementEvent = (XmlTemplateEngineStreamReader.StartElementEvent)pEvent;
                this.handleStartElement(startElementEvent);
            }
        }
    }

    private String getElementText() throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        while (this.xsr.hasNext()) {
            int type = this.xsr.next();
            switch (type) {
                case 2: {
                    return sb.toString();
                }
                case 4: 
                case 6: 
                case 12: {
                    sb.append(this.xsr.getText());
                    break;
                }
                case 3: 
                case 5: {
                    throw new XMLStreamException("Unexpected event: " + type + ", expected EndElement|Characters|CData|Space|Comment");
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream, missing EndElement event.");
    }

    private void parseElement() throws XMLStreamException, IOException {
        while (this.xsr.hasNext()) {
            int type = this.xsr.next();
            switch (type) {
                case 10: {
                    throw new XMLStreamException("Invalid event type: ATTRIBUTE");
                }
                case 2: {
                    throw new XMLStreamException("Invalid event type: END_ELEMENT");
                }
                case 11: {
                    this.handleDTD();
                    break;
                }
                case 1: {
                    this.handleStartElement((XmlTemplateEngineStreamReader.StartElementEvent)this.xsr.createEvent());
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters(type, this.xsr.getText());
                    break;
                }
                case 5: {
                    this.handleComment();
                    break;
                }
                case 7: {
                    this.handleStartDocument();
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    break;
                }
                case 9: {
                    this.handleEntityReference();
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction();
                }
            }
        }
    }

    private void handleDTD() throws IOException {
        this.write("xsw.writeDTD(");
        this.writeEscaped(this.xsr.getText());
        this.write(")");
    }

    private void handleStartDocument() throws IOException {
    }

    private void handleEndDocument() throws IOException {
        this.write("xsw.close()\n");
    }

    private void handleEntityReference() throws IOException {
        this.write("xsw.writeEntityRef(");
        this.writeEscaped(this.xsr.getText());
        this.write(")\n");
    }

    private void handleCharacters(int pEventType, String pText) throws XMLStreamException, IOException {
        this.write("buffer = ");
        this.writeEscaped(pText);
        this.write("\n");
        switch (pEventType) {
            case 4: 
            case 6: {
                this.write("xsw.writeCharacters(buffer)\n");
                break;
            }
            case 12: {
                this.write("xsw.writeCData(buffer)\n");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid event type: " + pEventType);
            }
        }
    }

    private void handleComment() throws XMLStreamException, IOException {
        this.write("buffer = ");
        this.writeEscaped(this.xsr.getText());
        this.write("\n");
        this.write("xsw.writeComment(buffer)\n");
    }

    private void handleProcessingInstruction() throws IOException {
        String data = this.xsr.getPIData();
        if (data == null) {
            this.write("xsw.writeProcessingInstruction(");
            this.writeEscaped(this.xsr.getPITarget());
            this.write(")\n");
        } else {
            this.write("xsw.writeProcessingInstruction(");
            this.writeEscaped(this.xsr.getPITarget());
            this.write(", ");
            this.writeEscaped(data);
            this.write(")\n");
        }
    }

    private void handleScriptletInstruction(XmlTemplateEngineStreamReader.StartElementEvent pEvent) throws XMLStreamException, IOException {
        String text = this.getElementText();
        this.write(text);
        this.write("\n");
    }

    private void handleElementInstruction(XmlTemplateEngineStreamReader.StartElementEvent pEvent) throws XMLStreamException, IOException {
        String value = this.getAttributeValue(pEvent, ATTR_NAME);
        if (value == null) {
            throw new XMLStreamException("Missing attribute 'gsp:name' for '" + pEvent.getName() + "'.", pEvent.getLocation());
        }
        this.writeNamespaceDeclarations(pEvent);
        this.write("qName = xsw.getQName(");
        this.writeEscaped(value);
        this.write(")\n");
        this.write("xsw.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI())\n");
        this.writeNamespaces(pEvent);
        this.writeElementAttributes(pEvent);
        this.handleElementContent();
        this.write("xsw.writeEndElement()\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleStartElement(XmlTemplateEngineStreamReader.StartElementEvent pEvent) throws XMLStreamException, IOException {
        QName name = pEvent.getName();
        String uri = name.getNamespaceURI();
        String localName = name.getLocalPart();
        if ("http://namespaces.csutils.sf.net/groovy/xml/XmlTemplateEngine".equals(uri)) {
            if ("scriptlet".equals(localName)) {
                this.handleScriptletInstruction(pEvent);
                return;
            } else {
                if (!"element".equals(localName)) throw new XMLStreamException("Unknown instruction: " + localName + ", expected scriptlet", pEvent.getLocation());
                this.handleElementInstruction(pEvent);
            }
            return;
        } else {
            this.writeNamespaceDeclarations(pEvent);
            this.write("xsw.writeStartElement(");
            this.writeEscaped(name.getPrefix());
            this.write(", ");
            this.writeEscaped(localName);
            this.write(", ");
            this.writeEscaped(uri);
            this.write(")\n");
            this.writeNamespaces(pEvent);
            this.writeElementAttributes(pEvent);
            this.handleElementContent();
            this.write("xsw.writeEndElement()\n");
        }
    }

    private void handleElementContent() throws XMLStreamException, IOException {
        block8: while (this.xsr.hasNext()) {
            int type = this.xsr.next();
            switch (type) {
                default: {
                    throw new XMLStreamException("Invalid event type: " + type);
                }
                case 9: {
                    this.handleEntityReference();
                    continue block8;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters(type, this.xsr.getText());
                    continue block8;
                }
                case 5: {
                    this.handleComment();
                    continue block8;
                }
                case 3: {
                    this.handleProcessingInstruction();
                    continue block8;
                }
                case 1: {
                    this.handleStartElement((XmlTemplateEngineStreamReader.StartElementEvent)this.xsr.createEvent());
                    continue block8;
                }
                case 2: 
            }
            return;
        }
        throw new XMLStreamException("Unexpected end of stream, missing EndElement event.");
    }

    private String getAttributeValue(XmlTemplateEngineStreamReader.StartElementEvent pEvent, QName pQName) {
        int numAttrs = pEvent.getAttributeCount();
        for (int i = 0; i < numAttrs; ++i) {
            if (!pQName.equals(pEvent.getAttributeName(i))) continue;
            return pEvent.getAttributeValue(i);
        }
        return null;
    }

    private void writeAttribute(String pPrefix, String pUri, String pLocalName, String pValue) throws IOException {
        this.write("xsw.writeAttribute(");
        this.writeEscaped(pPrefix);
        this.write(",");
        this.writeEscaped(pUri);
        this.write(",");
        this.writeEscaped(pLocalName);
        this.write(",");
        this.writeEscaped(pValue);
        this.write(")\n");
    }

    private void writeElementAttributes(XmlTemplateEngineStreamReader.StartElementEvent pEvent) throws XMLStreamException, IOException {
        int numAttrs = pEvent.getAttributeCount();
        for (int i = 0; i < numAttrs; ++i) {
            QName qName = pEvent.getAttributeName(i);
            String uri = qName.getNamespaceURI();
            if ("http://namespaces.csutils.sf.net/groovy/xml/XmlTemplateEngine".equals(uri)) continue;
            this.writeAttribute(qName.getPrefix(), uri, qName.getLocalPart(), pEvent.getAttributeValue(i));
        }
        ArrayList<XmlTemplateEngineStreamReader.Event> attrEvents = new ArrayList<XmlTemplateEngineStreamReader.Event>();
        while (this.xsr.hasNext()) {
            XmlTemplateEngineStreamReader.StartElementEvent startElement;
            QName qName;
            this.xsr.next();
            XmlTemplateEngineStreamReader.Event event = this.xsr.createEvent();
            if (this.isAttributeEvent(event)) {
                attrEvents.add(event);
                continue;
            }
            if (event.getEventType() == 1 && (qName = (startElement = (XmlTemplateEngineStreamReader.StartElementEvent)event).getName()).getNamespaceURI().equals("http://namespaces.csutils.sf.net/groovy/xml/XmlTemplateEngine") && qName.getLocalPart().equals("attribute")) {
                for (XmlTemplateEngineStreamReader.Event attrEvent : attrEvents) {
                    this.applyAttributeEvent(attrEvent);
                }
                attrEvents.clear();
                String name = this.getAttributeValue(startElement, ATTR_SIMPLE_NAME);
                if (name == null) {
                    throw new XMLStreamException("Missing attribute: " + startElement.getName() + "/@name", startElement.getLocation());
                }
                String value = this.getAttributeValue(startElement, ATTR_SIMPLE_VALUE);
                if (value == null) {
                    throw new XMLStreamException("Missing attribute: " + startElement.getName() + "/@value", startElement.getLocation());
                }
                this.write("qName = xsr.getQName(");
                this.writeEscaped(name);
                this.write("xsw.writeAttribute(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), ");
                this.writeEscaped(value);
                this.write(")\n");
                continue;
            }
            this.xsr.pushBack(event);
            for (int i = attrEvents.size() - 1; i >= 0; --i) {
                this.xsr.pushBack((XmlTemplateEngineStreamReader.Event)attrEvents.get(i));
            }
            return;
        }
        throw new XMLStreamException("Unexpected end of stream, missing EndElement event.");
    }

    private void writeNamespaceDeclarations(XmlTemplateEngineStreamReader.StartElementEvent pEvent) throws IOException {
        this.write("xsw.startElement()\n");
        int numNamespaces = pEvent.getNamespaceCount();
        for (int i = 0; i < numNamespaces; ++i) {
            String uri = pEvent.getNamespaceURI(i);
            if ("http://namespaces.csutils.sf.net/groovy/xml/XmlTemplateEngine".equals(uri)) continue;
            String prefix = pEvent.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            this.write("xsw.declarePrefix(");
            this.writeEscaped(prefix);
            this.write(",");
            this.writeEscaped(uri);
            this.write(")\n");
        }
    }

    private void writeNamespaces(XmlTemplateEngineStreamReader.StartElementEvent pEvent) throws IOException {
        int numNamespaces = pEvent.getNamespaceCount();
        for (int i = 0; i < numNamespaces; ++i) {
            String uri = pEvent.getNamespaceURI(i);
            if ("http://namespaces.csutils.sf.net/groovy/xml/XmlTemplateEngine".equals(uri)) continue;
            String prefix = pEvent.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            this.write("xsw.writeNamespace(");
            this.writeEscaped(prefix);
            this.write(",");
            this.writeEscaped(uri);
            this.write(")\n");
        }
    }
}

