/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csutils.groovy;

import groovy.text.GStringTemplateEngine;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.csutils.core.registry.ConnectionProvider;
import net.sf.csutils.core.registry.DefaultConnectionProvider;
import net.sf.csutils.groovy.QueryEngine;
import net.sf.csutils.groovy.xml.XmlTemplateEngine;

public class Main {
    private String csUrl;
    private String csUser;
    private String csPassword;
    private String inputEncoding;
    private String outputEncoding;
    private File inputFile;
    private File outputFile;
    private TemplateType templateType = TemplateType.gstring;
    private URL inputURL;

    public TemplateType getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(TemplateType templateType) {
        this.templateType = templateType;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File pInputFile) {
        this.inputFile = pInputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File pOutputFile) {
        this.outputFile = pOutputFile;
    }

    public URL getInputURL() {
        return this.inputURL;
    }

    public void setInputURL(URL pInputURL) {
        this.inputURL = pInputURL;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String pInputEncoding) {
        this.inputEncoding = pInputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String pOutputEncoding) {
        this.outputEncoding = pOutputEncoding;
    }

    public String getCsUrl() {
        return this.csUrl;
    }

    public void setCsUrl(String pUrl) {
        this.csUrl = pUrl;
    }

    public String getCsUser() {
        return this.csUser;
    }

    public void setCsUser(String pUser) {
        this.csUser = pUser;
    }

    public String getCsPassword() {
        return this.csPassword;
    }

    public void setCsPassword(String pPassword) {
        this.csPassword = pPassword;
    }

    public List<Opt> getOptions() {
        Opt[] opts = new Opt[]{new StringOpt("csUrl", "CentraSite URL", "Sets the CentraSite URL.", true){

            @Override
            public void setValue(String pValue) {
                Main.this.setCsUrl(pValue);
            }
        }, new StringOpt("csUser", "CentraSite user", "Sets the CentraSite user.", true){

            @Override
            public void setValue(String pValue) {
                Main.this.setCsUser(pValue);
            }
        }, new StringOpt("csPassword", "CentraSite password", "Sets the CentraSite users password.", true){

            @Override
            public void setValue(String pValue) {
                Main.this.setCsPassword(pValue);
            }
        }, new StringOpt("inputEncoding", "Encoding", "Sets the templates encoding, defaults to UTF8.", false){

            @Override
            public void setValue(String pValue) {
                Main.this.setInputEncoding(pValue);
            }
        }, new StringOpt("outputEncoding", "Encoding", "Sets the output files encoding, defaults to UTF8.", false){

            @Override
            public void setValue(String pValue) {
                Main.this.setOutputEncoding(pValue);
            }
        }, new FileOpt("inputFile", "Input file", "Sets the input templates file.", false, true){

            @Override
            public void setValue(File pValue) {
                if (Main.this.getInputURL() != null) {
                    throw new UsageException("The options inputFile and inputURL are mutually exclusive.");
                }
                Main.this.setInputFile(pValue);
            }
        }, new URLOpt("inputUrl", "Input URL", "Sets the input templates URL.", false){

            @Override
            public void setValue(URL pValue) {
                if (Main.this.getInputFile() != null) {
                    throw new UsageException("The options inputFile and inputURL are mutually exclusive.");
                }
                Main.this.setInputURL(pValue);
            }
        }, new FileOpt("outputFile", "Output file", "Sets the output file.", false, false){

            @Override
            public void setValue(File pValue) {
                Main.this.setOutputFile(pValue);
            }
        }, new StringOpt("templateType", "Template type", "Sets the template type, either of simple|gstring|gxml|xml, defaults to gstring.", false){

            @Override
            public void setValue(String pValue) {
                try {
                    Main.this.setTemplateType(TemplateType.valueOf(pValue.toLowerCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new UsageException("Invalid value for option templateType: " + pValue + ", expexted simple|gstring|gxml|xml.");
                }
            }
        }, new BooleanOpt("help", "Usage message", "Prints the usage message and exits with error status."){

            @Override
            public void setValue(boolean pValue) {
                Main.this.usage(null, Main.this.getOptions());
            }
        }};
        return new ArrayList<Opt>(Arrays.asList(opts));
    }

    private String getIntro(Opt pOpt) {
        if (pOpt instanceof StringOpt) {
            return "  -" + pOpt.getName() + " <s>";
        }
        if (pOpt instanceof FileOpt) {
            return "  -" + pOpt.getName() + " <f>";
        }
        if (pOpt instanceof URLOpt) {
            return "  -" + pOpt.getName() + " <u>";
        }
        if (pOpt instanceof BooleanOpt) {
            return "  -" + pOpt.getName();
        }
        throw new IllegalStateException("Invalid option type: " + pOpt.getClass().getName());
    }

    private void show(int pIntroLength, List<Opt> pOptions) {
        for (Opt opt : pOptions) {
            StringBuilder intro = new StringBuilder(this.getIntro(opt));
            while (intro.length() < pIntroLength) {
                intro.append(' ');
            }
            System.err.println(intro + opt.getLongDescription());
        }
    }

    protected void usage(String pMessage, List<Opt> pOptions) {
        if (pMessage != null) {
            System.err.println(pMessage);
            System.err.println();
        }
        System.err.println("Usage: java " + this.getClass().getName() + " <options>");
        System.err.println();
        ArrayList<Opt> allOptions = new ArrayList<Opt>(pOptions);
        Collections.sort(allOptions, new Comparator<Opt>(){

            @Override
            public int compare(Opt o1, Opt o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        ArrayList<Opt> requiredOptions = new ArrayList<Opt>();
        ArrayList<Opt> optionalOptions = new ArrayList<Opt>();
        int maxIntroLength = 0;
        for (Opt opt : allOptions) {
            int introLength = this.getIntro(opt).length();
            if (introLength > maxIntroLength) {
                maxIntroLength = introLength;
            }
            if (opt.isRequired()) {
                requiredOptions.add(opt);
                continue;
            }
            optionalOptions.add(opt);
        }
        System.err.println("Required options are: ");
        this.show(maxIntroLength + 2, requiredOptions);
        System.err.println("Other options are: ");
        this.show(maxIntroLength + 2, optionalOptions);
        System.exit(1);
    }

    private OutputStream getNonCloseableOutputStream(OutputStream pOut) {
        return new FilterOutputStream(pOut){

            @Override
            public void close() throws IOException {
                super.close();
            }
        };
    }

    private InputStream getNonCloseableInputStream(InputStream pIn) {
        return new FilterInputStream(pIn){

            @Override
            public void close() throws IOException {
                super.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Writer getOutputWriter() throws IOException {
        OutputStream stream = null;
        try {
            File out = this.getOutputFile();
            stream = out == null || "-".equals(out.getName()) ? this.getNonCloseableOutputStream(System.out) : new FileOutputStream(this.getOutputFile());
            String encoding = this.getOutputEncoding() == null ? "UTF8" : this.getOutputEncoding();
            OutputStreamWriter writer = new OutputStreamWriter(stream, encoding);
            stream = null;
            OutputStreamWriter outputStreamWriter = writer;
            return outputStreamWriter;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Reader getInput() throws IOException {
        InputStream stream = null;
        try {
            File f = this.getInputFile();
            if (f == null) {
                URL u = this.getInputURL();
                if (u == null) {
                    stream = this.getNonCloseableInputStream(System.in);
                } else {
                    try {
                        stream = u.openStream();
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to open input URL " + u + ": " + e.getMessage(), e);
                    }
                }
            } else if ("-".equals(f.getName())) {
                stream = this.getNonCloseableInputStream(System.in);
            } else {
                try {
                    stream = new FileInputStream(f);
                }
                catch (IOException e) {
                    throw new IOException("Failed to open input file " + f.getPath() + ": " + e.getMessage(), e);
                }
            }
            String encoding = this.getInputEncoding() == null ? "UTF8" : this.getInputEncoding();
            InputStreamReader result = new InputStreamReader(stream, encoding);
            stream = null;
            InputStreamReader inputStreamReader = result;
            return inputStreamReader;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected TemplateEngine getTemplateEngine() throws Exception {
        switch (this.getTemplateType()) {
            case gstring: {
                return new GStringTemplateEngine();
            }
            case simple: {
                return new SimpleTemplateEngine();
            }
            case gxml: {
                return new groovy.text.XmlTemplateEngine();
            }
            case xml: {
                return new XmlTemplateEngine();
            }
        }
        throw new IllegalStateException("Invalid template type: " + (Object)((Object)this.getTemplateType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        URL dbUrl;
        try {
            dbUrl = new URL(this.getCsUrl());
        }
        catch (Exception e) {
            throw new UsageException("Invalid database URL: " + this.getCsUrl());
        }
        Reader reader = null;
        Writer writer = null;
        try {
            reader = this.getInput();
            TemplateEngine engine = this.getTemplateEngine();
            Template template = engine.createTemplate(reader);
            writer = this.getOutputWriter();
            QueryEngine.run(template, writer, (ConnectionProvider)new DefaultConnectionProvider(dbUrl, this.getCsUser(), this.getCsPassword()));
            writer.close();
            writer = null;
            reader.close();
            reader = null;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable t) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public static void main(String[] pArgs) throws Exception {
        Main main = new Main();
        Main.main(main, pArgs);
    }

    public static void main(Main pMain, String[] pArgs) throws Exception {
        List<Opt> options = pMain.getOptions();
        try {
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(pArgs));
            while (!args.isEmpty()) {
                String optName;
                String arg = (String)args.remove(0);
                if (arg.startsWith("--")) {
                    optName = arg.substring(2);
                } else if (arg.startsWith("-")) {
                    optName = arg.substring(1);
                } else {
                    throw new UsageException("Invalid option: " + arg);
                }
                Opt opt = null;
                for (Opt o : options) {
                    if (!o.getName().equals(optName)) continue;
                    opt = o;
                    break;
                }
                if (opt == null) {
                    throw new UsageException("Unknown option: " + arg);
                }
                if (opt instanceof StringOpt) {
                    if (args.isEmpty()) {
                        throw new UsageException("Option " + arg + " requires an argument (" + opt.getShortDescription() + ")");
                    }
                    ((StringOpt)opt).setValue((String)args.remove(0));
                } else if (opt instanceof FileOpt) {
                    if (args.isEmpty()) {
                        throw new UsageException("Option " + arg + " requires an argument (" + opt.getShortDescription() + ")");
                    }
                    File f = new File((String)args.remove(0));
                    FileOpt fileOpt = (FileOpt)opt;
                    if (fileOpt.isMustExist() && !f.isFile()) {
                        throw new UsageException("The file " + f.getPath() + ", specified by option " + arg + " does not exist.");
                    }
                    fileOpt.setValue(f);
                } else if (opt instanceof URLOpt) {
                    URL url;
                    if (args.isEmpty()) {
                        throw new UsageException("Option " + arg + " requires an argument (" + opt.getShortDescription() + ")");
                    }
                    String s = (String)args.remove(0);
                    try {
                        url = new URL(s);
                    }
                    catch (MalformedURLException e) {
                        throw new UsageException("Invalid URL " + s + ", specified by option " + arg);
                    }
                    URLOpt urlOpt = (URLOpt)opt;
                    urlOpt.setValue(url);
                } else {
                    throw new IllegalStateException("Invalid option type: " + opt.getClass().getName());
                }
                opt.setSet(true);
            }
            for (Opt opt : options) {
                if (!opt.isRequired() || opt.isSet()) continue;
                throw new UsageException("The mandatory option " + opt.getName() + " is missing.");
            }
            pMain.run();
        }
        catch (UsageException e) {
            pMain.usage(e.getMessage(), options);
        }
    }

    public static enum TemplateType {
        simple,
        gstring,
        gxml,
        xml;

    }

    public static class UsageException
    extends RuntimeException {
        private static final long serialVersionUID = -7702096820277892721L;

        public UsageException(String message) {
            super(message);
        }
    }

    public static abstract class URLOpt
    extends Opt {
        public URLOpt(String pName, String pShortDescription, String pLongDescription, boolean pRequired) {
            super(pName, pShortDescription, pLongDescription, pRequired);
        }

        public abstract void setValue(URL var1);
    }

    public static abstract class FileOpt
    extends Opt {
        private boolean mustExist;

        public FileOpt(String pName, String pShortDescription, String pLongDescription, boolean pRequired, boolean pMustExist) {
            super(pName, pShortDescription, pLongDescription, pRequired);
            this.mustExist = pMustExist;
        }

        public boolean isMustExist() {
            return this.mustExist;
        }

        public abstract void setValue(File var1);
    }

    public static abstract class BooleanOpt
    extends Opt {
        public BooleanOpt(String pName, String pShortDescription, String pLongDescription) {
            super(pName, pShortDescription, pLongDescription, false);
        }

        public abstract void setValue(boolean var1);
    }

    public static abstract class StringOpt
    extends Opt {
        public StringOpt(String pName, String pShortDescription, String pLongDescription, boolean pRequired) {
            super(pName, pShortDescription, pLongDescription, pRequired);
        }

        public abstract void setValue(String var1);
    }

    public static abstract class Opt {
        private final String name;
        private final String shortDescription;
        private final String longDescription;
        private final boolean isRequired;
        private boolean isSet;

        public Opt(String pName, String pShortDescription, String pLongDescription, boolean pRequired) {
            this.name = pName;
            this.shortDescription = pShortDescription;
            this.longDescription = pLongDescription;
            this.isRequired = pRequired;
        }

        protected void setSet(boolean pSet) {
            this.isSet = pSet;
        }

        public boolean isSet() {
            return this.isSet;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public String getName() {
            return this.name;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public String getLongDescription() {
            return this.longDescription;
        }
    }
}

