/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csutils.groovy;

import com.centrasite.jaxr.CentraSiteConnection;
import com.centrasite.jaxr.CentraSiteRegistryService;
import com.softwareag.centrasite.policy.model.GroovyEntity;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.text.Template;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.RegistryObject;
import net.sf.csutils.core.model.ROMetaModel;
import net.sf.csutils.core.query.CsqlParser;
import net.sf.csutils.core.query.CsqlStatement;
import net.sf.csutils.core.query.StatementUtils;
import net.sf.csutils.core.registry.ConnectionProvider;
import net.sf.csutils.core.registry.RegistryFacade;
import net.sf.csutils.groovy.InternationalStringMetaClass;
import net.sf.csutils.groovy.LocalizedStringMetaClass;
import net.sf.csutils.groovy.RegistryObjectMetaClass;
import net.sf.csutils.groovy.policy.GroovyEntityMetaClass;
import net.sf.csutils.groovy.proxy.ROMetaModelProxy;
import net.sf.csutils.groovy.proxy.ROModelAccessorProxy;
import net.sf.csutils.groovy.proxy.RegistryFacadeProxy;

public abstract class QueryEngine
implements GroovyObject {
    private MetaClass metaClass;

    public QueryEngine() {
        this.setMetaClass(GroovySystem.getMetaClassRegistry().getMetaClass(this.getClass()));
    }

    protected abstract ROMetaModel getMetaModel();

    protected abstract RegistryFacade getRegistryFacade();

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private String getQuery(Object pArgs, List<Object> pParameters) {
        if (pArgs != null) {
            Collection args;
            if (pArgs.getClass().isArray() && !pArgs.getClass().getComponentType().isPrimitive()) {
                Object[] args2 = (Object[])pArgs;
                if (args2.length > 0) {
                    String query = args2[0] == null ? null : args2[0].toString();
                    for (int i = 1; i < args2.length; ++i) {
                        pParameters.add(args2[i]);
                    }
                    return query;
                }
            } else if (pArgs instanceof Collection && !(args = (Collection)pArgs).isEmpty()) {
                String query;
                Iterator iter = args.iterator();
                Object o = iter.next();
                String string = query = o == null ? null : o.toString();
                while (iter.hasNext()) {
                    pParameters.add(iter.next());
                }
                return query;
            }
        }
        throw new IllegalArgumentException("Missing argument: query string.");
    }

    private CsqlStatement query(Object pArgs) throws JAXRException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        String query = this.getQuery(pArgs, parameters);
        CsqlStatement stmt = new CsqlParser(this.getMetaModel()).parse(this.getRegistryFacade(), query);
        StatementUtils.setParameters((CsqlStatement)stmt, parameters);
        return stmt;
    }

    public Object invokeMethod(String pName, Object pArgs) {
        try {
            if ("query".equals(pName)) {
                CsqlStatement st = this.query(pArgs);
                List list = st.executeQuery();
                ArrayList result = new ArrayList(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    result.add(list.get(i));
                }
                return result;
            }
            if ("queryArray".equals(pName)) {
                CsqlStatement st = this.query(pArgs);
                List list = st.executeArrayQuery();
                ArrayList<RegistryObject[]> result = new ArrayList<RegistryObject[]>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    RegistryObject[] row = (RegistryObject[])list.get(i);
                    RegistryObject[] ros = new RegistryObject[row.length];
                    for (int j = 0; j < ros.length; ++j) {
                        ros[j] = row[j];
                    }
                    result.add(ros);
                }
                return result;
            }
            if ("createQuery".equals(pName)) {
                return this.query(pArgs);
            }
            throw new IllegalArgumentException("Invalid method name: " + pName);
        }
        catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public Object getProperty(String pPropertyName) {
        throw new IllegalArgumentException("Invalid property name: " + pPropertyName);
    }

    public void setProperty(String pPropertyName, Object pNewValue) {
        throw new IllegalArgumentException("Invalid property name: " + pPropertyName);
    }

    public static void run(Template pTemplate, Writer pWriter, ConnectionProvider pProvider) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        QueryEngine.run(map, pTemplate, pWriter, pProvider);
    }

    public static void run(Closure pClosure, RegistryObject pObject) throws JAXRException {
        CentraSiteRegistryService rs = (CentraSiteRegistryService)pObject.getLifeCycleManager().getRegistryService();
        CentraSiteConnection conn = rs.getConnection();
        ConnectionProvider provider = new ConnectionProvider((Connection)conn){
            final /* synthetic */ Connection val$conn;
            {
                this.val$conn = connection;
            }

            public Connection getConnection() throws JAXRException {
                return this.val$conn;
            }
        };
        QueryEngine.run(pClosure, provider, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Closure pClosure, ConnectionProvider pProvider, boolean pCloseConnection) {
        RegistryFacadeProxy registryFacadeProxy = new RegistryFacadeProxy(pProvider);
        try {
            final RegistryFacadeProxy rfProxy = registryFacadeProxy;
            final ROMetaModelProxy roMetaModelProxy = new ROMetaModelProxy(rfProxy);
            final MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
            registry.setMetaClassCreationHandle(new MetaClassRegistry.MetaClassCreationHandle(){

                protected MetaClass createNormalMetaClass(Class theClass, MetaClassRegistry pRegistry) {
                    MetaClass metaClass = super.createNormalMetaClass(theClass, registry);
                    if (LocalizedString.class.isAssignableFrom(theClass)) {
                        return new LocalizedStringMetaClass(metaClass);
                    }
                    if (InternationalString.class.isAssignableFrom(theClass)) {
                        return new InternationalStringMetaClass(metaClass);
                    }
                    if (GroovyEntity.class.isAssignableFrom(theClass)) {
                        return new GroovyEntityMetaClass(metaClass){

                            @Override
                            protected ROMetaModel getMetaModel() {
                                return roMetaModelProxy.getROMetaModel();
                            }
                        };
                    }
                    if (RegistryObject.class.isAssignableFrom(theClass)) {
                        return new RegistryObjectMetaClass(metaClass){

                            @Override
                            protected ROMetaModel getMetaModel() {
                                return roMetaModelProxy.getROMetaModel();
                            }
                        };
                    }
                    return metaClass;
                }
            });
            MetaClass groovyEntityMetaClass = registry.getMetaClass(GroovyEntity.class);
            if (!(groovyEntityMetaClass instanceof GroovyEntityMetaClass)) {
                registry.setMetaClass(GroovyEntity.class, registry.getMetaClassCreationHandler().create(GroovyEntityMetaClass.class, registry));
            }
            QueryEngine queryEngine = new QueryEngine(){

                @Override
                protected RegistryFacade getRegistryFacade() {
                    return rfProxy.getRegistryFacade();
                }

                @Override
                protected ROMetaModel getMetaModel() {
                    return roMetaModelProxy.getROMetaModel();
                }
            };
            pClosure.call(new Object[]{registryFacadeProxy, roMetaModelProxy, queryEngine});
            if (pCloseConnection) {
                registryFacadeProxy.close();
            }
            registryFacadeProxy = null;
        }
        finally {
            if (pCloseConnection && registryFacadeProxy != null) {
                try {
                    registryFacadeProxy.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Map<String, Object> pMap, Template pTemplate, Writer pWriter, ConnectionProvider pProvider) throws IOException {
        RegistryFacadeProxy registryFacadeProxy = new RegistryFacadeProxy(pProvider);
        try {
            final RegistryFacadeProxy rfProxy = registryFacadeProxy;
            pMap.put("registryFacade", rfProxy);
            final ROMetaModelProxy roMetaModelProxy = new ROMetaModelProxy(rfProxy);
            pMap.put("registryMetaModel", roMetaModelProxy);
            ROModelAccessorProxy modelAccProxy = new ROModelAccessorProxy(rfProxy);
            pMap.put("modelAccessor", modelAccProxy);
            ROModelAccessorProxy metaModelAccProxy = new ROModelAccessorProxy(rfProxy);
            pMap.put("metaModelAccessor", metaModelAccProxy);
            final MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
            registry.setMetaClassCreationHandle(new MetaClassRegistry.MetaClassCreationHandle(){

                protected MetaClass createNormalMetaClass(Class theClass, MetaClassRegistry pRegistry) {
                    MetaClass metaClass = super.createNormalMetaClass(theClass, registry);
                    if (LocalizedString.class.isAssignableFrom(theClass)) {
                        return new LocalizedStringMetaClass(metaClass);
                    }
                    if (InternationalString.class.isAssignableFrom(theClass)) {
                        return new InternationalStringMetaClass(metaClass);
                    }
                    if (RegistryObject.class.isAssignableFrom(theClass)) {
                        return new RegistryObjectMetaClass(metaClass){

                            @Override
                            protected ROMetaModel getMetaModel() {
                                return roMetaModelProxy.getROMetaModel();
                            }
                        };
                    }
                    return metaClass;
                }
            });
            QueryEngine queryEngine = new QueryEngine(){

                @Override
                protected RegistryFacade getRegistryFacade() {
                    return rfProxy.getRegistryFacade();
                }

                @Override
                protected ROMetaModel getMetaModel() {
                    return roMetaModelProxy.getROMetaModel();
                }
            };
            pMap.put("queryEngine", queryEngine);
            pTemplate.make(pMap).writeTo(pWriter);
            registryFacadeProxy.close();
            registryFacadeProxy = null;
        }
        finally {
            if (registryFacadeProxy != null) {
                try {
                    registryFacadeProxy.close();
                }
                catch (Throwable t) {}
            }
        }
    }
}

