/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csutils.groovy.xml;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XmlTemplateEngineStreamReader {
    private final XMLStreamReader xsr;
    private Event currentEvent;
    private final List<Event> events = new ArrayList<Event>();

    public XmlTemplateEngineStreamReader(Reader pReader) throws XMLStreamException {
        this(new StreamSource(pReader));
    }

    public XmlTemplateEngineStreamReader(InputStream pStream) throws XMLStreamException {
        this(new StreamSource(pStream));
    }

    public XmlTemplateEngineStreamReader(Source pSource) throws XMLStreamException {
        this.xsr = XMLInputFactory.newInstance().createXMLStreamReader(pSource);
    }

    public boolean hasNext() throws XMLStreamException {
        return !this.events.isEmpty() || this.xsr.hasNext();
    }

    public int next() throws XMLStreamException {
        int result;
        if (this.events.isEmpty()) {
            this.currentEvent = null;
            result = this.xsr.next();
        } else {
            this.currentEvent = this.events.remove(0);
            result = this.currentEvent.getEventType();
        }
        return result;
    }

    public int getEventType() {
        if (this.currentEvent == null) {
            return this.xsr.getEventType();
        }
        return this.currentEvent.getEventType();
    }

    private TextEvent assertTextEvent(Event pEvent) {
        if (pEvent instanceof TextEvent) {
            return (TextEvent)pEvent;
        }
        throw new IllegalStateException("Current event is an instance of " + this.currentEvent.getClass().getName() + ", not an instance of " + TextEvent.class.getName());
    }

    private StartElementEvent assertStartElementEvent(Event pEvent) {
        if (pEvent instanceof StartElementEvent) {
            return (StartElementEvent)pEvent;
        }
        throw new IllegalStateException("Current event is an instance of " + this.currentEvent.getClass().getName() + ", not an instance of " + StartElementEvent.class.getName());
    }

    public String getText() {
        if (this.currentEvent == null) {
            return this.xsr.getText();
        }
        return this.assertTextEvent(this.currentEvent).getText();
    }

    public String getPIData() {
        if (this.currentEvent == null) {
            return this.xsr.getPIData();
        }
        throw new IllegalStateException("Unable to cache processing instructions.");
    }

    public String getPITarget() {
        if (this.currentEvent == null) {
            return this.xsr.getPITarget();
        }
        throw new IllegalStateException("Unable to cache processing instructions.");
    }

    public QName getName() {
        if (this.currentEvent == null) {
            return this.xsr.getName();
        }
        return this.assertStartElementEvent(this.currentEvent).getName();
    }

    public Location getLocation() {
        if (this.currentEvent == null) {
            return this.xsr.getLocation();
        }
        return this.currentEvent.getLocation();
    }

    public int getAttributeCount() {
        if (this.currentEvent == null) {
            return this.xsr.getAttributeCount();
        }
        return this.assertStartElementEvent(this.currentEvent).getAttributeCount();
    }

    public QName getAttributeName(int i) {
        if (this.currentEvent == null) {
            return this.xsr.getAttributeName(i);
        }
        return this.assertStartElementEvent(this.currentEvent).getAttributeName(i);
    }

    public String getAttributeValue(int i) {
        if (this.currentEvent == null) {
            return this.xsr.getAttributeValue(i);
        }
        return this.assertStartElementEvent(this.currentEvent).getAttributeValue(i);
    }

    public int getNamespaceCount() {
        if (this.currentEvent == null) {
            return this.xsr.getNamespaceCount();
        }
        return this.assertStartElementEvent(this.currentEvent).getNamespaceCount();
    }

    public String getNamespacePrefix(int pIndex) {
        if (this.currentEvent == null) {
            return this.xsr.getNamespacePrefix(pIndex);
        }
        return this.assertStartElementEvent(this.currentEvent).getNamespacePrefix(pIndex);
    }

    public String getNamespaceURI(int pIndex) {
        if (this.currentEvent == null) {
            return this.xsr.getNamespaceURI(pIndex);
        }
        return this.assertStartElementEvent(this.currentEvent).getNamespaceURI(pIndex);
    }

    public Event createEvent() {
        if (this.currentEvent == null) {
            int type = this.getEventType();
            switch (type) {
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    return new TextEvent(this.getLocation(), type, this.getText());
                }
                case 1: {
                    Attribute[] attrs = new Attribute[this.getAttributeCount()];
                    for (int i = 0; i < attrs.length; ++i) {
                        attrs[i] = new Attribute(this.getAttributeName(i), this.getAttributeValue(i));
                    }
                    Namespace[] namespaces = new Namespace[this.getNamespaceCount()];
                    for (int i = 0; i < namespaces.length; ++i) {
                        namespaces[i] = new Namespace(this.getNamespacePrefix(i), this.getNamespaceURI(i));
                    }
                    return new StartElementEvent(this.getLocation(), this.getName(), attrs, namespaces);
                }
            }
            throw new IllegalStateException("Invalid event type: " + type);
        }
        return this.currentEvent;
    }

    public void pushBack(Event event) {
        this.events.add(0, event);
        this.currentEvent = null;
    }

    public static class StartElementEvent
    extends Event {
        private final QName name;
        private final Attribute[] attrs;
        private final Namespace[] namespaces;

        StartElementEvent(Location pLocation, QName pQName, Attribute[] pAttrs, Namespace[] pNamespaces) {
            super(pLocation, 1);
            this.attrs = pAttrs;
            this.name = pQName;
            this.namespaces = pNamespaces;
        }

        public QName getName() {
            return this.name;
        }

        public int getAttributeCount() {
            return this.attrs.length;
        }

        public QName getAttributeName(int pIndex) {
            return this.attrs[pIndex].name;
        }

        public String getAttributeValue(int pIndex) {
            return this.attrs[pIndex].value;
        }

        public int getNamespaceCount() {
            return this.namespaces.length;
        }

        public String getNamespacePrefix(int pIndex) {
            return this.namespaces[pIndex].getPrefix();
        }

        public String getNamespaceURI(int pIndex) {
            return this.namespaces[pIndex].getNamespaceURI();
        }
    }

    public static class Namespace {
        private final String prefix;
        private final String uri;

        Namespace(String pPrefix, String pUri) {
            if (pUri == null) {
                throw new IllegalArgumentException("The namespace URI must not be null.");
            }
            this.prefix = pPrefix;
            this.uri = pUri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespaceURI() {
            return this.uri;
        }
    }

    private static class Attribute {
        final QName name;
        final String value;

        Attribute(QName pName, String pValue) {
            this.name = pName;
            this.value = pValue;
        }
    }

    public static class TextEvent
    extends Event {
        private final String text;

        TextEvent(Location pLocation, int pType, String pText) {
            super(pLocation, pType);
            this.text = pText;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Event {
        private final int type;
        private final Location location;

        Event(Location pLocation, int pType) {
            this.location = pLocation;
            this.type = pType;
        }

        public int getEventType() {
            return this.type;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

