package net.sf.csutils.groovy;

import java.lang.reflect.UndeclaredThrowableException;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.InternationalString;

import groovy.lang.DelegatingMetaClass;
import groovy.lang.MetaClass;


/**
 * Meta class for {@link InternationalString}.
 */
public class InternationalStringMetaClass extends DelegatingMetaClass {
    /**
     * Creates a new instance.
     * @param pDelegate The proxied meta class.
     */
    public InternationalStringMetaClass(MetaClass pDelegate) {
        super(pDelegate);
    }

    @Override
    public Object invokeMethod(Object pObject, String pMethodName, Object[] pArgs) {
        try {
            if ("localizedStrings".equals(pMethodName)) {
                GroovyObjects.checkNoArgs(pMethodName, pArgs);
                return ((InternationalString) pObject).getLocalizedStrings();
            }
            return super.invokeMethod(pObject, pMethodName, pArgs);
        } catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

}
