package net.sf.csutils.groovy;

import groovy.lang.DelegatingMetaClass;
import groovy.lang.MetaClass;

import java.lang.reflect.UndeclaredThrowableException;

import javax.xml.registry.JAXRException;

import net.sf.csutils.core.utils.RegistryObjects;

import org.codehaus.groovy.runtime.InvokerHelper;

public class LocalizedStringMetaClass extends DelegatingMetaClass {
    public LocalizedStringMetaClass(MetaClass pMetaClass) {
        super(pMetaClass);
    }

    @Override
    public Object getProperty(Object pObject, String pName) {
        final javax.xml.registry.infomodel.LocalizedString ls = (javax.xml.registry.infomodel.LocalizedString) pObject;
        try {
            if ("charsetName".equals(pName)) {
                return ls.getCharsetName();
            }
            if ("locale".equals(pName)) {
                return ls.getLocale().toString();
            }
            if ("value".equals(pName)) {
                return ls.getValue();
            }
            throw new IllegalArgumentException("Invalid property name: " + pName);
        } catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void setProperty(Object pObject, String pName, Object pValue) {
        final javax.xml.registry.infomodel.LocalizedString ls = (javax.xml.registry.infomodel.LocalizedString) pObject;
        try {
            if ("charsetName".equals(pName)) {
                ls.setCharsetName(InvokerHelper.toString(pValue));
            }
            if ("locale".equals(pName)) {
                ls.setLocale(RegistryObjects.asLocale(InvokerHelper.toString(pValue)));
            }
            if ("value".equals(pName)) {
                ls.setValue(InvokerHelper.toString(pValue));
            }
            throw new IllegalArgumentException("Invalid property name: " + pName);
        } catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}
