package net.sf.csutils.groovy.policy;

import java.lang.reflect.Field;
import java.lang.reflect.UndeclaredThrowableException;

import javax.xml.registry.infomodel.RegistryObject;

import com.softwareag.centrasite.policy.model.GroovyEntity;

import groovy.lang.MetaClass;
import net.sf.csutils.groovy.GroovyObjects;
import net.sf.csutils.groovy.RegistryObjectMetaClass;


/**
 * 
 */
public abstract class GroovyEntityMetaClass extends RegistryObjectMetaClass {
    private static final String KEY;
    private static final String SERVICE_LOCALNAME;
    private static final Field roField;
    static {
        try {
            final Class<?> cl = GroovyEntity.class;
            final Field keyField = cl.getDeclaredField("KEY");
            keyField.setAccessible(true);
            KEY = (String) keyField.get(null);
            final Field serviceField = cl.getDeclaredField("SERVICE_LOCALNAME");
            serviceField.setAccessible(true);
            SERVICE_LOCALNAME = (String) serviceField.get(null);
            roField = cl.getDeclaredField("ro");
            roField.setAccessible(true);
        } catch (NoSuchFieldException e) {
            throw new UndeclaredThrowableException(e);
        } catch (IllegalArgumentException e) {
            throw new UndeclaredThrowableException(e);
        } catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
    
    /**
     * Creates a new instance.
     * @param pDelegate The proxied meta class.
     */
    public GroovyEntityMetaClass(MetaClass pDelegate) {
        super(pDelegate);
    }

    /**
     * Reads the wrapped {@link RegistryObject} instance from the given
     * GroovyEntity.
     * @param pEntity The GroovyEntity instance.
     * @return The wrapped {@link RegistryObject} instance.
     */
    public static RegistryObject getRegistryObject(Object pEntity) {
        try {
            return (RegistryObject) roField.get(pEntity);
        } catch (IllegalArgumentException e) {
            throw new UndeclaredThrowableException(e);
        } catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
    
    @Override
    public void setProperty(Object pObject, String pProperty, Object pValues) {
        super.setProperty(getRegistryObject(pObject), pProperty, pValues);
    }

    @Override
    public Object invokeMethod(Object pObject, String pMethodName,
            Object[] pArgs) {
        if ("attribute".equals(pMethodName)) {
            final String propertyName = GroovyObjects.checkStringArg(pMethodName, pArgs);
            if (KEY.equals(propertyName)
                    ||  SERVICE_LOCALNAME.equals(propertyName)) {
                return delegate.invokeMethod(pObject, pMethodName, pArgs);
            }
        }
        if ("nativeObject".equals(pMethodName)) {
            GroovyObjects.checkNoArgs(pMethodName, pArgs);
            return getRegistryObject(pObject);
        }
        return super.invokeMethod(getRegistryObject(pObject), pMethodName, pArgs);
    }

    @Override
    public Object getProperty(Object pObject, String pProperty) {
        if ("name".equals(pProperty)
                ||  "description".equals(pProperty)
                ||  "status".equals(pProperty)
                ||  "owner".equals(pProperty)) {
            return delegate.getProperty(pObject, pProperty);
        }
        return super.getProperty(getRegistryObject(pObject), pProperty);
    }
}
