package net.sf.csutils.groovy.proxy;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;

public abstract class AbstractProxy implements GroovyObject {
	private final MetaClass proxiedMetaClass;
	private MetaClass metaClass;
	private Object proxiedObject;

	protected AbstractProxy(Class<?> pProxiedClass) {
		proxiedMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(pProxiedClass);
		setMetaClass(GroovySystem.getMetaClassRegistry().getMetaClass(getClass()));
	}
	
	protected abstract Object newProxiedObject();

	protected boolean hasProxiedObject() {
		return proxiedObject != null;
	}

	protected Object getProxiedObject() {
		if (proxiedObject == null) {
			proxiedObject = newProxiedObject();
		}
		return proxiedObject;
	}
	
	public Object invokeMethod(String pMethodName, Object pArgs) {
		return proxiedMetaClass.invokeMethod(getProxiedObject(), pMethodName, pArgs); 
	}

	public Object getProperty(String pPropertyName) {
		return proxiedMetaClass.getProperty(getProxiedObject(), pPropertyName);
	}

	public void setProperty(String pPropertyName, Object pValue) {
		proxiedMetaClass.setProperty(getProxiedObject(), pPropertyName, pValue);
	}

	public MetaClass getMetaClass() {
		return metaClass;
	}

	public void setMetaClass(MetaClass pMetaClass) {
		metaClass = pMetaClass;
	}
}
