package net.sf.csutils.groovy.proxy;

import net.sf.csutils.core.model.ROMetaModel;
import net.sf.csutils.core.model.impl.DynamicROMetaModel;


/**
 * Proxy object, which allows to defer creating a registry object model.
 */
public class ROMetaModelProxy extends AbstractProxy {
	private final RegistryFacadeProxy registryFacadeProxy;

	public ROMetaModelProxy(RegistryFacadeProxy pRegistryFacadeProxy) {
		super(ROMetaModel.class);
		registryFacadeProxy = pRegistryFacadeProxy;
	}

	@Override
	protected Object newProxiedObject() {
		return new DynamicROMetaModel(registryFacadeProxy.getRegistryFacade());
	}

	public ROMetaModel getROMetaModel() {
		return (ROMetaModel) getProxiedObject();
	}
}
