package net.sf.csutils.groovy.proxy;

import java.lang.reflect.UndeclaredThrowableException;

import javax.xml.registry.JAXRException;

import net.sf.csutils.core.registry.ConnectionProvider;
import net.sf.csutils.core.registry.ModelDrivenRegistryFacade;
import net.sf.csutils.core.registry.SimpleModelDrivenRegistryFacade;


/**
 * Proxy object, which allows to defer creating a connection to the CentraSite
 * registry.
 */
public class RegistryFacadeProxy extends AbstractProxy {
	private final ConnectionProvider provider;
	
	public RegistryFacadeProxy(ConnectionProvider pProvider) {
		super(ModelDrivenRegistryFacade.class);
		provider = pProvider;
	}

	@Override
	protected Object newProxiedObject() {
		try {
			return new SimpleModelDrivenRegistryFacade(provider.getConnection());
		} catch (JAXRException e) {
			throw new UndeclaredThrowableException(e);
		}
	}

	public ModelDrivenRegistryFacade getRegistryFacade() {
		return (ModelDrivenRegistryFacade) getProxiedObject();
	}
	
	public void close() {
		if (hasProxiedObject()) {
			try {
				getRegistryFacade().getConnection().close();
			} catch (JAXRException e) {
				throw new UndeclaredThrowableException(e);
			}
		}
	}
}
