package net.sf.csutils.groovy.xml;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.text.Template;
import groovy.text.TemplateEngine;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;

import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;

import org.codehaus.groovy.control.CompilationFailedException;

public class XmlTemplateEngine extends TemplateEngine {
	/**
	 * The namespace URI of the script elements.
	 */
	public static final String NS_URI = "http://namespaces.csutils.sf.net/groovy/xml/XmlTemplateEngine";

	private final GroovyShell groovyShell;

	public XmlTemplateEngine() {
		this(new GroovyShell());
	}

	public XmlTemplateEngine(GroovyShell pGroovyShell) {
		groovyShell = pGroovyShell;
	}

	public XmlTemplateEngine(ClassLoader pClassLoader) {
		this(new GroovyShell(pClassLoader));
	}

	@Override
	public Template createTemplate(Reader pReader) 
			throws CompilationFailedException, ClassNotFoundException, IOException {
		try {
			final StringWriter sw = new StringWriter();
			final XmlTemplateEngineParser ch = new XmlTemplateEngineParser(pReader, sw);
			ch.parse();
			final String text = sw.toString();
			final Script script = groovyShell.parse(text);
			return new XmlTemplateEngineTemplate(script, text);
		} catch (XMLStreamException e) {
			throw new CompilationFailedException(0, null, e);
		} catch (FactoryConfigurationError e) {
			throw new CompilationFailedException(0, null, e);
		}
	}
}
