package net.sf.csutils.groovy.xml;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamResult;

public class XmlTemplateEngineStreamWriter implements XMLStreamWriter {
	private final XMLStreamWriter xsw;
	private final List<String> prefixes = new ArrayList<String>();
	private final List<Integer> contextSizes = new ArrayList<Integer>();

	public void close() throws XMLStreamException {
		xsw.close();
	}

	public void flush() throws XMLStreamException {
		xsw.flush();
	}

	public NamespaceContext getNamespaceContext() {
		return xsw.getNamespaceContext();
	}

	public String getPrefix(String arg0) throws XMLStreamException {
		return xsw.getPrefix(arg0);
	}

	public Object getProperty(String arg0) throws IllegalArgumentException {
		return xsw.getProperty(arg0);
	}

	public void setDefaultNamespace(String arg0) throws XMLStreamException {
		xsw.setDefaultNamespace(arg0);
	}

	public void setNamespaceContext(NamespaceContext arg0)
			throws XMLStreamException {
		xsw.setNamespaceContext(arg0);
	}

	public void setPrefix(String arg0, String arg1) throws XMLStreamException {
		xsw.setPrefix(arg0, arg1);
	}

	public void writeAttribute(String arg0, String arg1, String arg2,
			String arg3) throws XMLStreamException {
		xsw.writeAttribute(arg0, arg1, arg2, arg3);
	}

	public void writeAttribute(String arg0, String arg1, String arg2)
			throws XMLStreamException {
		xsw.writeAttribute(arg0, arg1, arg2);
	}

	public void writeAttribute(String arg0, String arg1)
			throws XMLStreamException {
		xsw.writeAttribute(arg0, arg1);
	}

	public void writeCData(String arg0) throws XMLStreamException {
		xsw.writeCData(arg0);
	}

	public void writeCharacters(char[] arg0, int arg1, int arg2)
			throws XMLStreamException {
		xsw.writeCharacters(arg0, arg1, arg2);
	}

	public void writeCharacters(String arg0) throws XMLStreamException {
		xsw.writeCharacters(arg0);
	}

	public void writeComment(String arg0) throws XMLStreamException {
		xsw.writeComment(arg0);
	}

	public void writeDTD(String arg0) throws XMLStreamException {
		xsw.writeDTD(arg0);
	}

	public void writeDefaultNamespace(String arg0) throws XMLStreamException {
		xsw.writeDefaultNamespace(arg0);
	}

	public void writeEmptyElement(String arg0, String arg1, String arg2)
			throws XMLStreamException {
		xsw.writeEmptyElement(arg0, arg1, arg2);
	}

	public void writeEmptyElement(String arg0, String arg1)
			throws XMLStreamException {
		xsw.writeEmptyElement(arg0, arg1);
	}

	public void writeEmptyElement(String arg0) throws XMLStreamException {
		xsw.writeEmptyElement(arg0);
	}

	public void writeEndDocument() throws XMLStreamException {
		xsw.writeEndDocument();
	}

	public void writeEndElement() throws XMLStreamException {
		xsw.writeEndElement();
		final Integer contextSize = contextSizes.remove(contextSizes.size()-1);
		while (prefixes.size() > contextSize.intValue()) {
			prefixes.remove(prefixes.size()-1);
		}
	}

	public void writeEntityRef(String arg0) throws XMLStreamException {
		xsw.writeEntityRef(arg0);
	}

	public void writeNamespace(String arg0, String arg1)
			throws XMLStreamException {
		xsw.writeNamespace(arg0, arg1);
	}

	public void writeProcessingInstruction(String arg0, String arg1)
			throws XMLStreamException {
		xsw.writeProcessingInstruction(arg0, arg1);
	}

	public void writeProcessingInstruction(String arg0)
			throws XMLStreamException {
		xsw.writeProcessingInstruction(arg0);
	}

	public void writeStartDocument() throws XMLStreamException {
		xsw.writeStartDocument();
	}

	public void writeStartDocument(String arg0, String arg1)
			throws XMLStreamException {
		xsw.writeStartDocument(arg0, arg1);
	}

	public void writeStartDocument(String arg0) throws XMLStreamException {
		xsw.writeStartDocument(arg0);
	}

	public void writeStartElement(String arg0, String arg1, String arg2)
			throws XMLStreamException {
		xsw.writeStartElement(arg0, arg1, arg2);
	}

	public void writeStartElement(String arg0, String arg1)
			throws XMLStreamException {
		xsw.writeStartElement(arg0, arg1);
	}

	public void writeStartElement(String arg0) throws XMLStreamException {
		xsw.writeStartElement(arg0);
	}

	public XmlTemplateEngineStreamWriter(OutputStream pStream) throws XMLStreamException {
		this(new StreamResult(pStream));
	}

	public XmlTemplateEngineStreamWriter(Writer pWriter) throws XMLStreamException {
		this(new StreamResult(pWriter));
	}

	public XmlTemplateEngineStreamWriter(StreamResult pResult) throws XMLStreamException {
		final XMLOutputFactory factory = XMLOutputFactory.newInstance();
		factory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, Boolean.TRUE);
		xsw = factory.createXMLStreamWriter(pResult);
	}

	public void startElement() {
		contextSizes.add(Integer.valueOf(prefixes.size()));
	}
	
	public void declarePrefix(String pPrefix, String pNamespaceURI) {
		prefixes.add(pPrefix);
		prefixes.add(pNamespaceURI);
	}

	private String getNamespaceURI(String pPrefix) {
		if (XMLConstants.XML_NS_PREFIX.equals(pPrefix)) {
			return XMLConstants.XML_NS_URI;
		}
		for (int i = prefixes.size()-2;  i >= 0;  i -= 2) {
			if (pPrefix.equals(prefixes.get(i))) {
				return prefixes.get(i+1);
			}
		}
		if (XMLConstants.DEFAULT_NS_PREFIX.equals(pPrefix)) {
			return XMLConstants.NULL_NS_URI;
		}
		return null;
	}
	
	public QName getQName(String pName) throws XMLStreamException {
		final int offset = pName.indexOf(':');
		if (offset == -1) {
			return new QName(getNamespaceURI(XMLConstants.DEFAULT_NS_PREFIX), pName, XMLConstants.DEFAULT_NS_PREFIX);
		}
		final String prefix = pName.substring(0, offset);
		final String localPart = pName.substring(offset+1);
		final String uri = getNamespaceURI(prefix);
		if (uri == null) {
			throw new XMLStreamException("Undeclared namespace prefix: " + prefix);
		}
		return new QName(uri, localPart, prefix);
	}
}
