package net.sf.csutils.groovy.xml;

import groovy.lang.Binding;
import groovy.lang.Script;
import groovy.lang.Writable;
import groovy.text.Template;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

import org.codehaus.groovy.runtime.InvokerHelper;

public final class XmlTemplateEngineTemplate implements Template {
	private final Script script;
	private final String text;

	public XmlTemplateEngineTemplate(Script script, String text) {
		this.script = script;
		this.text = text;
	}

	/**
	 * Returns the template text.
	 * @return The template text.
	 */
	public String getText() { return text; }

	public Writable make() { return make(new HashMap<String,Object>()); }

	public Writable make(@SuppressWarnings("rawtypes") final Map pMap) {
		return new Writable(){
			public Writer writeTo(Writer pWriter) throws IOException {
				final Script clonedScript = InvokerHelper.createScript(script.getClass(), new Binding(pMap));
				clonedScript.setProperty("out", pWriter);
				clonedScript.run();
				return pWriter;
			}
		};
	}
}
