package net.sf.csutils.impexp.impimpl;

import net.sf.csutils.core.model.QName;


/**
 * Representation of an asset type.
 */
public class AssetType {
    public enum Type {
        /**
         * The object is identified by its registry object key.
         * This is the default.
         */
        key,
        /**
         * The object is identified by its registry object name.
         * Assumes, that names are unique, even considering the
         * locale.
         */
        name,
        /**
         * The object is identified by a slot value.
         * Assumes, that these values are unique.
         */
        slotValue,
    }

    private final Type type;
    private final QName qName;

    public AssetType(Type pType, QName pQName) {
        if (pType == null) {
            throw new IllegalArgumentException("The type must not be null.");
        }
        if (pQName == null) {
            throw new IllegalArgumentException("The name must not be null.");
        }
        type = pType;
        qName = pQName;
    }

    /**
     * Returns the asset types type.
     * @return The asset types type
     */
    public Type getType() {
        return type;
    }

    /**
     * Returns the asset types name.
     * @return The asset types name
     */
    public QName getQName() {
        return qName;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * (31 * 1 + type.hashCode()) + qName.getNamespaceURI().hashCode()) + qName.getLocalPart().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AssetType other = (AssetType) obj;
        if (getType() != other.getType()) {
            return false;
        }
        final QName myName = getQName();
        final QName otherName = other.getQName();
        return myName.getNamespaceURI().equals(otherName.getNamespaceURI())
           &&  myName.getLocalPart().equals(otherName.getLocalPart());
    }
}
