package net.sf.csutils.impexp.impimpl;

import java.util.Comparator;

import net.sf.csutils.core.model.QName;


/**
 * A comparator for asset types.
 */
public class AssetTypeComparator implements Comparator<AssetType> {
    private final boolean isCaseSensitive;

    public AssetTypeComparator(boolean pCaseSensitive) {
        isCaseSensitive = pCaseSensitive;
    }
    
    @Override
    public int compare(AssetType pType1, AssetType pType2) {
        int result = pType1.getType().ordinal() - pType2.getType().ordinal();
        if (result == 0) {
            final QName qName1 = pType1.getQName();
            final QName qName2 = pType2.getQName();
            if (isCaseSensitive) {
                result = qName1.getNamespaceURI().compareToIgnoreCase(qName2.getNamespaceURI());
            } else {
                result = qName1.getNamespaceURI().compareTo(qName2.getNamespaceURI());
            }
            if (result == 0) {
                if (isCaseSensitive) {
                    result = qName1.getLocalPart().compareToIgnoreCase(qName2.getLocalPart());
                } else {
                    result = qName1.getLocalPart().compareToIgnoreCase(qName2.getLocalPart());
                }
            }
        }
        return result;
    }
}
