package net.sf.csutils.impexp.impimpl;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;


public abstract class ContextProvidingParser {
    public static class ParseException extends Exception {
        private static final long serialVersionUID = -2255671576755433360L;

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public ParseException(String message) {
            super(message);
        }

        public ParseException(Throwable cause) {
            super(cause);
        }
    }

    public interface Context {
        NamespaceContext getNamespaceContext();
        Location getLocation();
    }

    private static final ThreadLocal<Context> ctx = new ThreadLocal<Context>();

    protected abstract void doParse(XMLStreamReader pReader) throws ParseException;

    public void parse(final XMLStreamReader pReader) throws ParseException {
        final Context context = new Context(){
            @Override
            public NamespaceContext getNamespaceContext() {
                return pReader.getNamespaceContext();
            }

            @Override
            public Location getLocation() {
                return pReader.getLocation();
            }
        };
        ctx.set(context);
        try {
            doParse(pReader);
        } finally {
            ctx.set(null);
        }
    }

    public static Context getContext() {
        return ctx.get();
    }
}
