package net.sf.csutils.impexp.impimpl;



/**
 * Abstract base class for keys in the map of registry objects.
 */
public abstract class Key implements Comparable<Key> {
    private final AssetType type;

    protected Key(AssetType pType) {
        if (pType == null) {
            throw new IllegalArgumentException("The asset type must not be null.");
        }
        type = pType;
    }

    public AssetType getType() {
        return type;
    }
    
    @Override
    public String toString() {
        return super.toString() + "[" + type.getType().name() + "," + type.getQName() + "]";
    }
}
