package net.sf.csutils.impexp.impimpl;

import java.util.Comparator;


/**
 * A comparator for keys. It ensures that the ordering of keys is, in that order:
 * <ol>
 *   <li>By type, using the ordinal number of {@link Key#getType()}.</li>
 *   <li>By object type, using {@link NameKey#getName()}.</li>
 *   <li>By object specific data, using {@link Key#compareTo(Key)}.</li>
 * </ol>
 * In other words, instances of {@link KeyKey} are the first, followed by
 * instances of {@link NameKey}, and finally instances of {@link SlotValueKey}.
 * Within instances of the same type, the ordering is by object type name.
 * And within instances of the same type, and object type name, the
 * ordering depends on the type: For instances of {@link KeyKey}, the
 * ordering is by {@link KeyKey#getKey() key}. For instances of
 * {@link NameKey}, it is by {@link NameKey#getName()}, and for instances
 * of {@link SlotValueKey}, it is by {@link SlotValueKey#getValue()}.
 */
public class KeyComparator implements Comparator<Key> {
    private static final AssetTypeComparator typeComparator = new AssetTypeComparator(true);

    @Override
    public int compare(Key pKey1, Key pKey2) {
        int result = typeComparator.compare(pKey1.getType(), pKey2.getType());
        if (result == 0) {
            result = pKey1.compareTo(pKey2);
        }
        return result;
    }
}
