package net.sf.csutils.impexp.impimpl;


/**
 * Key of an object, which is identified by its JAXR key.
 */
public class KeyKey extends Key {
    private final String key;

    public KeyKey(AssetType pType, String pKey) {
        super(pType);
        if (pKey == null) {
            throw new IllegalArgumentException("The key must not be null.");
        }
        key = pKey;
    }
    
    public String getKey() {
        return key;
    }

    @Override
    public int compareTo(Key pArg) {
        KeyKey other = (KeyKey) pArg;
        return key.compareTo(other.key);
    }

    @Override
    public int hashCode() {
        return 31 + key.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        KeyKey other = (KeyKey) obj;
        return key.equals(other.key);
    }

    @Override
    public String toString() {
        return super.toString() + "[key=" + getKey() + "]";
    }
}
