package net.sf.csutils.impexp.impimpl;

import java.util.Locale;


/**
 * Key of an object, which is identified by its JAXR key.
 */
public class NameKey extends Key {
    private final String name;
    private final Locale locale;

    public NameKey(AssetType pType, String pName, Locale pLocale) {
        super(pType);
        name = pName;
        locale = pLocale;
    }
    
    public String getName() {
        return name;
    }

    public Locale getLocale() {
        return locale;
    }

    @Override
    public int compareTo(Key pArg) {
        NameKey other = (NameKey) pArg;
        if (name == null) {
            return other.name == null ? 0 : -1;
        }
        if (other.name == null) {
            return 1;
        }
        int result = name.compareTo(other.name);
        if (result == 0) {
            if (locale == null) {
                return other.locale == null ? 0 : -1;
            }
            if (other.locale == null) {
                return 1;
            }
            result = locale.toString().compareTo(other.locale.toString());
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = 31 + ((name == null) ? 0 : name.hashCode());
        return 31 * result + ((locale == null) ? 0 : locale.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        NameKey other = (NameKey) obj;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (locale == null) {
            if (other.locale != null)
                return false;
        } else if (!locale.equals(other.locale))
            return false;
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "[locale=" + locale + ",name=" + name + "]";
    }
}
