package net.sf.csutils.impexp.impimpl;


/**
 * Key of an object, which is identified by its JAXR key.
 */
public class SlotValueKey extends Key {
    private final Object value;

    public SlotValueKey(SlotValueAssetType pType, Object pValue) {
        super(pType);
        if (pValue == null) {
            throw new IllegalArgumentException("The slot value must not be null.");
        }
        value = pValue;
    }

    public Object getValue() {
        return value;
    }

    @Override
    @SuppressWarnings("unchecked")
    public int compareTo(Key pArg) {
        SlotValueKey other = (SlotValueKey) pArg;
        return ((Comparable<Object>) value).compareTo(other.value);
    }

    @Override
    public int hashCode() {
        return 31 + value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SlotValueKey other = (SlotValueKey) obj;
        return value.equals(other.value);
    }

    @Override
    public String toString() {
        return super.toString() + "[key=" + getValue() + "]";
    }
}
