package net.sf.csutils.impexp.jdbc;


/**
 * Data container for storing the required metadata information of
 * one column in beans.
 */
public class JdbcDbColumn {
	private final JdbcDbTable table;
	private final String name;
	private final int type;
	private final boolean nullable;

	JdbcDbColumn(JdbcDbTable pTable, String pName, int pType, boolean pNullable) {
		table = pTable;
		name = pName;
		type = pType;
		nullable = pNullable;
	}

	public JdbcDbTable getTable() {
		return table;
	}

	public String getName() {
		return name;
	}

	public int getType() {
		return type;
	}

	public boolean isNullable() {
		return nullable;
	}
}
