package net.sf.csutils.impexp.jdbc;

import java.util.ArrayList;
import java.util.List;


/**
 * Data container for storing the required metadata information of one
 * foreign key in beans.
 */
public class JdbcDbForeignKey {
	private final JdbcDbTable localTable, foreignTable;
	private final List<JdbcDbColumn> localColumns = new ArrayList<JdbcDbColumn>();
	private final List<JdbcDbColumn> foreignColumns = new ArrayList<JdbcDbColumn>();
	private String associationType;

	public JdbcDbForeignKey(JdbcDbTable pLocalTable, JdbcDbTable pForeignTable) {
		localTable = pLocalTable;
		foreignTable = pForeignTable;
	}

	public List<JdbcDbColumn> getLocalColumns() {
		return localColumns;
	}

	public List<JdbcDbColumn> getForeignColumns() {
		return foreignColumns;
	}

	public JdbcDbTable getLocalTable() {
		return localTable;
	}

	public JdbcDbTable getForeignTable() {
		return foreignTable;
	}

	public String getAssociationType() {
		return associationType;
	}

	public void setAssociationType(String pType) {
		associationType = pType;
	}
}
