package net.sf.csutils.impexp.jdbc;

import java.util.ArrayList;
import java.util.List;

import net.sf.csutils.core.model.QName;


/**
 * Data container for storing the required metadata information of
 * one table in beans.
 */
public class JdbcDbTable {
	private final JdbcDbMetaData database;
	private final String catalog, schema, name;
	private final List<JdbcDbColumn> columns = new ArrayList<JdbcDbColumn>();
	private final List<JdbcDbColumn> primaryKeyColumns = new ArrayList<JdbcDbColumn>();
	private final List<JdbcDbForeignKey> foreignKeys = new ArrayList<JdbcDbForeignKey>();
	private QName qName;
	private JdbcDbColumn nameColumn, descriptionColumn;

	public JdbcDbTable(JdbcDbMetaData pDatabase, String pCatalog, String pSchema, String pName) {
		database = pDatabase;
		catalog = pCatalog;
		schema = pSchema;
		name = pName;
	}
	
	public JdbcDbMetaData getDatabase() {
		return database;
	}

	public String getCatalog() {
		return catalog;
	}

	public String getSchema() {
		return schema;
	}

	public String getName() {
		return name;
	}

	public JdbcDbColumn getNameColumn() {
		return nameColumn;
	}

	public void setNameColumn(JdbcDbColumn nameColumn) {
		this.nameColumn = nameColumn;
	}

	public JdbcDbColumn getDescriptionColumn() {
		return descriptionColumn;
	}

	public void setDescriptionColumn(JdbcDbColumn descriptionColumn) {
		this.descriptionColumn = descriptionColumn;
	}

	public List<JdbcDbColumn> getColumns() {
		return columns;
	}

	public List<JdbcDbColumn> getPrimaryKeyColumns() {
		return primaryKeyColumns;
	}

	public List<JdbcDbForeignKey> getForeignKeys() {
		return foreignKeys;
	}

	public QName getQName() {
		return qName;
	}

	public void setQName(QName qName) {
		this.qName = qName;
	}
}
