package net.sf.csutils.impexp.jdbc;

import java.sql.Types;

import net.sf.csutils.jdbcExporter.vo.JdbcExport;

import org.apache.log4j.Logger;

public final class JdbcExportTableFilter implements
		JdbcDbTableFilter {
	private static final Logger log = Logger.getLogger(JdbcExportTableFilter.class);
	private final JdbcExport jdbcExport;
	private final String catalog, schema;

	public JdbcExportTableFilter(JdbcExport pJdbcExport, String pCatalog, String pSchema) {
		jdbcExport = pJdbcExport;
		catalog = pCatalog;
		schema = pSchema;
	}

	@Override
	public boolean isNameColumn(String pCatalog, String pSchema, String pTable,
			String pColumn) {
		final JdbcExport.Table table = getTable(jdbcExport, pCatalog, pSchema, pTable);
		if (table != null) {
			return table.getNameColumn() != null  &&
				table.getNameColumn().equalsIgnoreCase(pColumn);
		}
		return false;
	}

	@Override
	public boolean isExported(String pTableCat, String pTableSchem,
			String pTableName, String pColumnName, int pColumnType) {
		final JdbcExport.Table table = getTable(jdbcExport, pTableCat, pTableSchem, pTableName);
		if (table != null) {
			final JdbcExport.Table.Column column = getColumn(table, pColumnName);
			if (column != null) {
				switch (pColumnType) {
					case Types.VARCHAR:
					case Types.TINYINT:
					case Types.SMALLINT:
					case Types.INTEGER:
					case Types.BIGINT:
					case Types.BOOLEAN:
					case Types.DOUBLE:
					case Types.FLOAT:
						return true;
					default:
						log.error("Ignoring unknown data type " + pColumnType
							+ " for column " + pColumnName
							+ " in table " + JdbcDbReader.asString(pTableCat, pTableSchem, pTableName));
				}
			}
		}
		return false;
	}

	@Override
	public boolean isExported(String pCatalog, String pSchema, String pTable) {
		final JdbcExport.Table table = getTable(jdbcExport, pCatalog, pSchema, pTable);
		return table != null;
	}

	@Override
	public boolean isDescriptionColumn(String pCatalog, String pSchema,
			String pTable, String pColumn) {
		final JdbcExport.Table table = getTable(jdbcExport, pCatalog, pSchema, pTable);
		if (table != null) {
			return table.getDescriptionColumn() != null  &&
				table.getDescriptionColumn().equalsIgnoreCase(pColumn);
		}
		return false;
	}

	protected JdbcExport.Table getTable(JdbcExport pDatabaseDescription,
			String pCatalog, String pSchema, String pTable) {
		for (JdbcExport.Table table: pDatabaseDescription.getTable()) {
			if (catalog != null  &&  !catalog.equalsIgnoreCase(pCatalog)) {
				continue;
			}
			if (schema != null  &&  !catalog.equalsIgnoreCase(pCatalog)) {
				continue;
			}
			if (table.getName().equalsIgnoreCase(pTable)) {
				return table;
			}
		}
		return null;
	}

	protected JdbcExport.Table.Column getColumn(JdbcExport.Table pTable, String pColumn) {
		for (JdbcExport.Table.Column col : pTable.getColumn()) {
			if (col.getName().equalsIgnoreCase(pColumn)) {
				return col;
			}
		}
		return null;
	}
}