/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.accessor;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Key;

import org.apache.labs.jaxmas.registry.infomodel.AssociationImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectLoader;


/**
 * Implementation of {@link ROAccessor} for associations.
 */
public class AssociationAccessor extends AbstractROAccessor<Association> {
    private static final RegistryObjectLoader rol;
    static {
        try {
            rol = new RegistryObjectLoader(ROAccessors.ObjectTypes.ASSOCIATION, null, null);
        } catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        } catch (SQLException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static final AssociationAccessor theInstance = new AssociationAccessor();

    /**
     * Private constructor, to ensure singleton pattern.
     */
    private AssociationAccessor() {
        // Does nothing.
    }

    /**
     * Returns the singleton instance.
     */
    public static AssociationAccessor getInstance() {
        return theInstance;
    }

    @Override
    public int getRegistryObjectType() {
        return ROAccessors.ObjectTypes.ASSOCIATION.ordinal();
    }

    @Override
    public Association newInstance(RegistryServiceImpl pRegistryService, Key pKey)
            throws JAXRException {
        return new AssociationImpl(pRegistryService, pKey);
    }

    @Override
    public RegistryObjectLoader getRegistryObjectLoader() {
        return rol;
    }
}
