/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.accessor;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;

import org.apache.labs.jaxmas.registry.infomodel.ConceptImpl;
import org.apache.labs.jaxmas.registry.infomodel.RegistryServiceImpl;
import org.apache.labs.jaxmas.registry.sql.RegistryObjectLoader;


/**
 * Implementation of {@link ROAccessor} for concepts.
 */
public class ConceptAccessor extends AbstractROAccessor<Concept> {
    private static final RegistryObjectLoader rol;
    static {
        try {
            rol = new RegistryObjectLoader(ROAccessors.ObjectTypes.CONCEPT, null, null);
        } catch (JAXRException e) {
            throw new UndeclaredThrowableException(e);
        } catch (SQLException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static final ConceptAccessor theInstance = new ConceptAccessor();

    /**
     * Private accessor, to implement singleton pattern.
     */
    private ConceptAccessor() {
        // Nothing to do
    }

    /**
     * Returns the singleton instance.
     */
    public static ConceptAccessor getInstance() {
        return theInstance;
    }

	@Override
	public int getRegistryObjectType() {
		return ROAccessors.ObjectTypes.CONCEPT.ordinal();
	}

    @Override
    protected Concept newInstance(RegistryServiceImpl pRegistryService, Key pKey) throws JAXRException {
        return new ConceptImpl(pRegistryService, pKey);
    }

    @Override
    public RegistryObjectLoader getRegistryObjectLoader() {
        return rol;
    }
}
