/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.sql.Timestamp;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.AuditableEvent;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.User;

import org.apache.labs.jaxmas.registry.accessor.AuditableEventAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;


/**
 * Implementation of {@link AuditableEvent}.
 */
public class AuditableEventImpl extends RegistryObjectImpl<AuditableEvent> implements AuditableEvent {
    /**
     * Creates a new instance with the given registry service and key.
     */
    public AuditableEventImpl(RegistryServiceImpl pRegistryService, Key pKey) {
        super(pRegistryService, pKey);
    }

    @Override
    public ROAccessor<AuditableEvent> getROLoader() {
        return AuditableEventAccessor.getInstance();
    }

    @Override
    public int getEventType() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public RegistryObject getRegistryObject() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public Timestamp getTimestamp() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public User getUser() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }
}
