/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;

/**
 * Default implementation of {@link BulkResponse}.
 */
public class BulkResponseImpl implements BulkResponse {
	private final Collection<?> collection;
	private Collection<Throwable> exceptions;
	private String requestId;
	private int status;

	/**
	 * Creates a new instance with the given collection of result objects.
	 */
	public BulkResponseImpl(Collection<?> pCollection) {
		collection = pCollection;
	}
	
	@SuppressWarnings("rawtypes")
    @Override
	public Collection getCollection() throws JAXRException {
		return collection;
	}

	@SuppressWarnings("rawtypes")
    @Override
	public Collection getExceptions() throws JAXRException {
		return exceptions;
	}

	/**
	 * Sets the exception collection.
	 */
	public void setExceptions(Collection<Throwable> pExceptions) {
		exceptions = pExceptions;
	}

	@Override
	public boolean isPartialResponse() throws JAXRException {
		return false;
	}

	@Override
	public String getRequestId() throws JAXRException {
		return requestId;
	}

	@Override
	public int getStatus() throws JAXRException {
		return status;
	}

	@Override
	public boolean isAvailable() throws JAXRException {
		return true;
	}

	/**
	 * Sets the request id.
	 */
	public void setRequestId(String pRequestId) {
		requestId = pRequestId;
	}

	/**
	 * Sets the response status.
	 */
	public void setStatus(int pStatus) {
		status = pStatus;
	}
}
