/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Key;

import org.apache.labs.jaxmas.registry.accessor.ClassificationSchemeAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessors;


/**
 * Default implementation of {@link BusinessLifecycleManager}.
 */
public class BusinessLifeCycleManagerImpl extends LifeCycleManagerImpl implements BusinessLifeCycleManager {
	/**
	 * Creates a new instance with the given registry service,
	 */
	public BusinessLifeCycleManagerImpl(RegistryServiceImpl pRegistryService) {
		super(pRegistryService);
	}

	@Override
	public void confirmAssociation(Association pAssoc) throws JAXRException, InvalidRequestException {
	    throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public BulkResponse deleteAssociations(@SuppressWarnings("rawtypes") Collection pAssociationKeys) throws JAXRException {
	    return deleteObjects(pAssociationKeys);
	}

	@Override
	public BulkResponse deleteClassificationSchemes(@SuppressWarnings("rawtypes") Collection pSchemeKeys)
			throws JAXRException {
	    final List<Key> list = new ArrayList<Key>();
	    final RegistryService rs = getRegistryService();
	    final BulkResponse br = rs.getBusinessQueryManager().getRegistryObjects(pSchemeKeys);
	    if (br != null) {
	        final Collection<?> classificationSchemes = br.getCollection();
	        if (classificationSchemes != null) {
	            final ClassificationSchemeAccessor csa = ROAccessors.getClassificationSchemeAccessor();
	            for (Object o : classificationSchemes) {
	                ClassificationScheme cs = (ClassificationScheme) o;
	                csa.remove(rs, cs);
	                list.add(cs.getKey());
	            }
	        }
	    }
	    return new BulkResponseImpl(list);
	}

	@Override
	public BulkResponse deleteConcepts(@SuppressWarnings("rawtypes") Collection pConceptKeys) throws JAXRException {
	    return deleteObjects(pConceptKeys);
	}

	@Override
	public BulkResponse deleteOrganizations(@SuppressWarnings("rawtypes") Collection pOrganizationKeys) throws JAXRException {
		return deleteObjects(pOrganizationKeys);
	}

	@Override
	public BulkResponse deleteServiceBindings(@SuppressWarnings("rawtypes") Collection pBindingKeys)throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public BulkResponse deleteServices(@SuppressWarnings("rawtypes") Collection pServiceKeys) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public BulkResponse saveAssociations(@SuppressWarnings("rawtypes") Collection pAssociations, boolean pReplace) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public BulkResponse saveClassificationSchemes(@SuppressWarnings("rawtypes") Collection pClassificationSchemes) throws JAXRException {
		return saveObjects(pClassificationSchemes);
	}

	@Override
	public BulkResponse saveConcepts(@SuppressWarnings("rawtypes") Collection pConcepts) throws JAXRException {
		return saveObjects(pConcepts);
	}

	@Override
	public BulkResponse saveOrganizations(@SuppressWarnings("rawtypes") Collection pOrganizations) throws JAXRException {
		return saveObjects(pOrganizations);
	}

	@Override
	public BulkResponse saveServiceBindings(@SuppressWarnings("rawtypes") Collection pBindings) throws JAXRException {
		return saveServiceBindings(pBindings);
	}

	@Override
	public BulkResponse saveServices(@SuppressWarnings("rawtypes") Collection pServices) throws JAXRException {
		return saveObjects(pServices);
	}

	@Override
	public void unConfirmAssociation(Association pAssoc) throws JAXRException, InvalidRequestException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
		
	}
}
