/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.JAXRException;


/**
 * Default implementation of {@link CapabilityProfile}.
 */
public class CapabilityProfileImpl implements CapabilityProfile {
	private static final CapabilityProfile theInstance = new CapabilityProfileImpl();

	/**
	 * Private constructor, to ensure singleton pattern.
	 */
	private CapabilityProfileImpl() {
		// Nothing to do
	}

	/**
	 * Returns the singleton instance.
	 */
	public static final CapabilityProfile getInstance() { return theInstance; }
	
	@Override
	public int getCapabilityLevel() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public String getVersion() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}
}
