/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;

import org.apache.labs.jaxmas.registry.accessor.ClassificationSchemeAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;


/**
 * Default implementation of {@link ClassificationScheme}.
 */
public class ClassificationSchemeImpl extends RegistryEntryImpl<ClassificationScheme> implements ClassificationScheme {
    private int valueType;
	private final ConceptChildrenController children = new ConceptChildrenController(this);

	/**
	 * Creates a new instance with the given registry service.
	 */
	public ClassificationSchemeImpl(RegistryServiceImpl pRegistryService, Key pKey) {
		super(pRegistryService, pKey);
	}


	@Override
	public boolean isExternal() throws JAXRException {
		return false;
	}

	@Override
	public int getValueType() throws JAXRException {
		return valueType;
	}

	@Override
	public void setValueType(int pValueType) throws JAXRException {
		valueType = pValueType;
	}


    @Override
    public  ROAccessor<ClassificationScheme> getROLoader() {
        return ClassificationSchemeAccessor.getInstance();
    }


    @Override
    public void addChildConcept(Concept pConcept) throws JAXRException {
        children.addChildConcept(pConcept);
    }

    @SuppressWarnings("unchecked")
    @Override
    public void addChildConcepts(@SuppressWarnings("rawtypes") Collection pConcepts) throws JAXRException {
        children.addChildConcepts(pConcepts);
    }


    @Override
    public int getChildConceptCount() throws JAXRException {
        return children.getChildConceptCount();
    }


    @SuppressWarnings("rawtypes")
    @Override
    public Collection getChildrenConcepts() throws JAXRException {
        return children.getChildrenConcepts();
    }


    @SuppressWarnings("rawtypes")
    @Override
    public Collection getDescendantConcepts() throws JAXRException {
        return children.getDescendantConcepts();
    }


    @Override
    public void removeChildConcept(Concept pConcept) throws JAXRException {
        children.removeChildConcept(pConcept);
    }


    @SuppressWarnings("unchecked")
    @Override
    public void removeChildConcepts(@SuppressWarnings("rawtypes") Collection pConcepts) throws JAXRException {
        children.removeChildConcepts(pConcepts);
    }
}
