/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.Query;


/**
 * Default implementation of {@link DeclarativeQueryManager}.
 */
public class DeclarativeQueryManagerImpl extends QueryManagerImpl implements DeclarativeQueryManager {
	/**
	 * Creates a new instance with the given registry service.
	 */
	public DeclarativeQueryManagerImpl(RegistryServiceImpl pRegistryService) {
		super(pRegistryService);
	}

	@Override
	public Query createQuery(int pQueryType, String pQueryString) throws JAXRException, InvalidRequestException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public BulkResponse executeQuery(Query pQuery) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}
}
