/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;

import org.apache.labs.jaxmas.registry.accessor.ExternalIdentifierAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;


/**
 * Implementation of {@link ExternalLink}.
 */
public class ExternalIdentifierImpl extends RegistryObjectImpl<ExternalIdentifier> implements ExternalIdentifier {
    /**
     * Creates a new instance with the given registry service and key.
     */
    public ExternalIdentifierImpl(RegistryServiceImpl pRegistryService, Key pKey) {
        super(pRegistryService, pKey);
    }

    @Override
    public ROAccessor<ExternalIdentifier> getROLoader() {
        return ExternalIdentifierAccessor.getInstance();
    }

    @Override
    public ClassificationScheme getIdentificationScheme() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public RegistryObject getRegistryObject() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public String getValue() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public void setIdentificationScheme(ClassificationScheme pScheme) throws JAXRException {
            throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public void setValue(String pValue) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }
}
