/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;

import org.apache.labs.jaxmas.registry.accessor.ExternalLinkAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;


/**
 * Implementation of {@link ExternalLink}.
 */
public class ExternalLinkImpl extends RegistryObjectImpl<ExternalLink> implements ExternalLink {
    /**
     * Creates a new instance with the given registry service and key.
     */
    public ExternalLinkImpl(RegistryServiceImpl pRegistryService, Key pKey) {
        super(pRegistryService, pKey);
    }

    @Override
    public ROAccessor<ExternalLink> getROLoader() {
        return ExternalLinkAccessor.getInstance();
    }

    @Override
    public String getExternalURI() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public Collection<?> getLinkedObjects() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public void setExternalURI(String pUri) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public boolean getValidateURI() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public void setValidateURI(boolean pValidate) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }
}
