package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;


/**
 * JaxMas proprietary extension of {@link BusinessQueryManager} with
 * support for query to custom object types, closely modeled after
 * the <a href="http://documentation.softwareag.com/webmethods/soal8/jd/metamodelAPIclient/com/centrasite/jaxr/CentraSiteQueryManager.html">CentraSiteQueryManager</a>.
 */
public interface JaxMasQueryManager extends BusinessQueryManager {
	BulkResponse findObjects(Collection<String> pFindQualifiers,
            Collection<String> pObjectTypes,
            Collection<String> pNamePatterns,
            Collection<String> pDescriptionPatterns,
            Collection<?> pClassifications,
            Collection<?> pExternalIdentifiers,
            Collection<?> pExternalLinks)
        throws javax.xml.registry.JAXRException;
}
