/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;


/**
 * Default implementation of {@link Key}.
 */
public class KeyImpl implements Key {
	private String id;

	/**
	 * Creates a new instance with the given id.
	 */
	public KeyImpl(String pId) {
	    id = pId;
	}

	/**
     * Creates a new instance with no id.
     */
    public KeyImpl() {
        // Nothing to do
    }
	
	@Override
	public String getId() throws JAXRException {
		return id;
	}

	@Override
	public void setId(String pId) throws JAXRException {
	    id = pId;
	}

	@Override
	public int hashCode() {
	    return id == null ? 0 : id.hashCode();
	}

	@Override
	public boolean equals(Object pOther) {
	    if (pOther == null  ||  !pOther.getClass().equals(getClass())) {
	        return false;
	    }
	    KeyImpl other = (KeyImpl) pOther;
        if (id == null) {
	        return other == this;
	    }
	    return id.equals(other.id);
	}

	@Override
	public String toString() {
	    return id;
	}
}
