/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Locale;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.LocalizedString;


/**
 * Default implementation of {@link LocalizedString}.
 */
public class LocalizedStringImpl implements LocalizedString {
	private String charsetName;
	private Locale locale;
	private String value;

	@Override
	public String getCharsetName() throws JAXRException {
		return charsetName == null ? LocalizedString.DEFAULT_CHARSET_NAME : charsetName;
	}

	@Override
	public Locale getLocale() throws JAXRException {
		return locale;
	}

	@Override
	public String getValue() throws JAXRException {
		return value;
	}

	@Override
	public void setCharsetName(String pCharsetName) throws JAXRException {
		charsetName = pCharsetName;
	}

	@Override
	public void setLocale(Locale pLocale) throws JAXRException {
		locale = pLocale;
	}

	@Override
	public void setValue(String pValue) throws JAXRException {
		value = pValue;
	}
}
