/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.User;

import org.apache.labs.jaxmas.registry.accessor.OrganizationAccessor;
import org.apache.labs.jaxmas.registry.accessor.ROAccessor;


/**
 * Default implementation of {@link Organization}.
 */
public class OrganizationImpl extends RegistryObjectImpl<Organization> implements Organization {
    private Collection<Organization> childOrganizations = new ArrayList<Organization>();

	/**
	 * Creates a new instance.
	 */
	public OrganizationImpl(RegistryServiceImpl pRegistryService, Key pKey) {
		super(pRegistryService, pKey);
	}

	@Override
	public void addChildOrganization(Organization pOrganization) throws JAXRException {
		childOrganizations.add(pOrganization);
	}

	@SuppressWarnings("rawtypes")
	@Override
	public void addChildOrganizations(Collection pOrganizations) throws JAXRException {
		if (pOrganizations != null) {
			for (Object o : pOrganizations) {
				addChildOrganization((Organization) o);
			}
		}
	}

	@Override
	public void addService(Service pService) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);

	}

    @SuppressWarnings("rawtypes")
	@Override
	public void addServices(Collection pServices) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public void addUser(User pUser) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

    @SuppressWarnings("rawtypes")
	@Override
	public void addUsers(Collection pUsers) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public int getChildOrganizationCount() throws JAXRException {
		return childOrganizations.size();
	}

    @SuppressWarnings("rawtypes")
	@Override
	public Collection getChildOrganizations() throws JAXRException {
		return childOrganizations;
	}

    @SuppressWarnings("rawtypes")
	@Override
	public Collection getDescendantOrganizations() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public Organization getParentOrganization() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public PostalAddress getPostalAddress() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public User getPrimaryContact() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public Organization getRootOrganization() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

    @SuppressWarnings("rawtypes")
	@Override
	public Collection getServices() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

    @SuppressWarnings("rawtypes")
	@Override
	public Collection getTelephoneNumbers(String pPhoneType) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

    @SuppressWarnings("rawtypes")
	@Override
	public Collection getUsers() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public void removeChildOrganization(Organization pOrganization) throws JAXRException {
		childOrganizations.remove(pOrganization);
	}

    @SuppressWarnings("rawtypes")
	@Override
	public void removeChildOrganizations(Collection pOrganizations) throws JAXRException {
		if (pOrganizations != null) {
			for (Object o : pOrganizations) {
				removeChildOrganization((Organization) o);
			}
		}
	}

	@Override
	public void removeService(Service pService) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

    @SuppressWarnings("rawtypes")
	@Override
	public void removeServices(Collection pServices) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public void removeUser(User pUser) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

    @SuppressWarnings("rawtypes")
	@Override
	public void removeUsers(Collection pUsers) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public void setPostalAddress(PostalAddress pAddress) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
	public void setPrimaryContact(User pPrimaryContact) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

    @SuppressWarnings("rawtypes")
	@Override
	public void setTelephoneNumbers(Collection pPhoneNumbers) throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}

	@Override
    public ROAccessor<Organization> getROLoader() {
	    return OrganizationAccessor.getInstance();
	}
}
