/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.PersonName;


/**
 * Default implementation of {@link PersonName}.
 */
public class PersonNameImpl implements PersonName {
	private String firstName, fullName, lastName, middleName;

	@Override
	public String getFirstName() throws JAXRException {
		return firstName;
	}

	@Override
	public String getFullName() throws JAXRException {
		return fullName;
	}

	@Override
	public String getLastName() throws JAXRException {
		return lastName;
	}

	@Override
	public String getMiddleName() throws JAXRException {
		return middleName;
	}

	@Override
	public void setFirstName(String pFirstName) throws JAXRException {
		firstName = pFirstName;
	}

	@Override
	public void setFullName(String pFullName) throws JAXRException {
		fullName = pFullName;
	}

	@Override
	public void setLastName(String pLastName) throws JAXRException {
		lastName = pLastName;
	}

	@Override
	public void setMiddleName(String pMiddleName) throws JAXRException {
		middleName = pMiddleName;
	}
}
