/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Map;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Slot;


/**
 * Default implementation of {@link PostalAddress}.
 */
public class PostalAddressImpl extends ExtensibleObjectImpl implements PostalAddress {
	/**
	 * Creates a new instance.
	 */
	public PostalAddressImpl(RegistryServiceImpl pRegistryService) {
		super(pRegistryService);
	}

	private ClassificationScheme postalScheme;
	private String city, country, postalCode, street, stateOrProvince;
	private String streetNumber, type;

	@Override
	public String getCity() throws JAXRException {
		return city;
	}

	@Override
	public String getCountry() throws JAXRException {
		return country;
	}

	@Override
	public String getPostalCode() throws JAXRException {
		return postalCode;
	}

	@Override
	public ClassificationScheme getPostalScheme() throws JAXRException {
		return postalScheme;
	}

	@Override
	public String getStateOrProvince() throws JAXRException {
		return stateOrProvince;
	}

	@Override
	public String getStreet() throws JAXRException {
		return street;
	}

	@Override
	public String getStreetNumber() throws JAXRException {
		return streetNumber;
	}

	@Override
	public String getType() throws JAXRException {
		return type;
	}

	@Override
	public void setCity(String pCity) throws JAXRException {
		city = pCity;
	}

	@Override
	public void setCountry(String pCountry) throws JAXRException {
		country = pCountry;
	}

	@Override
	public void setPostalCode(String pPostalCode) throws JAXRException {
		postalCode = pPostalCode;
	}

	@Override
	public void setPostalScheme(ClassificationScheme pPostalScheme) throws JAXRException {
		postalScheme = pPostalScheme;
	}

	@Override
	public void setStateOrProvince(String pState) throws JAXRException {
		stateOrProvince = pState;
	}

	@Override
	public void setStreet(String pStreet) throws JAXRException {
		street = pStreet;
	}

	@Override
	public void setStreetNumber(String pStreetNumber) throws JAXRException {
		streetNumber = pStreetNumber;
	}

	@Override
	public void setType(String pType) throws JAXRException {
		type = pType;
	}

	@Override
	protected Map<String, Slot> loadSlots() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
	}
}
