/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;


/**
 * Enumeration of a registry objects possible states.
 */
public enum ROState {
    /**
     * The object has been created, but has never been saved.
     * This indicates, that
     * <ul>
     *   <li>no data must be loaded from the registry and</li>
     *   <li>a "save" must insert the object into the registry</li>
     * </ul>
     */
    created,
    /**
     * The object has been previously saved, but so far the
     * objects core data (apart from the objects key, or id)
     * has not yet been loaded. This indicates, that
     * <ul>
     *   <li>data must be loaded from the registry, if
     *     other core data is required</li>
     *   <li>a "save" must update the object in the registry</li>
     * </ul>
     */
    referenced,
    /**
     * The object has been previously saved and the registry
     * objects data is loaded. This indicates, that
     * <ul>
     *   <li>all core data is ready</li>
     *   <li>a "save" must update the object in the registry</li>
     * </ul>
     */
    loaded,
    /**
     * The object has been deleted. In particular, all core
     * data is invalid.
     */
    deleted
}
