/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;

import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.accessor.RegistryPackageAccessor;


/**
 * Default implementation of {@link RegistryPackage}.
 */
public class RegistryPackageImpl extends RegistryEntryImpl<RegistryPackage> implements RegistryPackage {
	private Collection<RegistryObject> registryObjects = new HashSet<RegistryObject>();

	/**
	 * Creates a new instance with the given registry service.
	 */
	public RegistryPackageImpl(RegistryServiceImpl pRegistryService, Key pKey) {
		super(pRegistryService, pKey);
	}

	@Override
    public ROAccessor<RegistryPackage> getROLoader() {
	    return RegistryPackageAccessor.getInstance();
	}

	@Override
	public void addRegistryObject(RegistryObject pRegistryObject) throws JAXRException {
		if (pRegistryObject == null) {
			throw new IllegalArgumentException(getNLSStrings().format(NLSStrings.NULL_PARAMETER, "pRegistryObject")); //$NON-NLS-1$
		}
		registryObjects.add(pRegistryObject);
	}

	@SuppressWarnings("rawtypes")
	@Override
	public void addRegistryObjects(Collection pRegistryObjects) throws JAXRException {
		if (pRegistryObjects == null) {
			throw new IllegalArgumentException(getNLSStrings().format(NLSStrings.NULL_PARAMETER, "pRegistryObjects")); //$NON-NLS-1$
		}
		for (Object o : pRegistryObjects) {
			addRegistryObject((RegistryObject) o);
		}
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Set getRegistryObjects() throws JAXRException {
		return Collections.unmodifiableSet((Set<?>) registryObjects);
	}

	@Override
	public void removeRegistryObject(RegistryObject pRegistryObject) throws JAXRException {
		if (pRegistryObject == null) {
			throw new IllegalArgumentException(getNLSStrings().format(NLSStrings.NULL_PARAMETER, "pRegistryObject")); //$NON-NLS-1$
		}
		registryObjects.remove(pRegistryObject);
	}

	@SuppressWarnings("rawtypes")
	@Override
	public void removeRegistryObjects(Collection pRegistryObjects) throws JAXRException {
		if (pRegistryObjects == null) {
			throw new IllegalArgumentException(getNLSStrings().format(NLSStrings.NULL_PARAMETER, "pRegistryObjects")); //$NON-NLS-1$
		}
		for (Object o : pRegistryObjects) {
			removeRegistryObject((RegistryObject) o);
		}
	}

}
