/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Slot;


/**
 * Default implementation of {@link Slot}.
 */
public class SlotImpl implements Slot {
	private String name;
	private String slotType;
	private Collection<?> values;

	@Override
	public String getName() throws JAXRException {
		return name;
	}

	@Override
	public void setName(String pName) throws JAXRException {
		name = pName;
	}

	@Override
	public String getSlotType() throws JAXRException {
		return slotType;
	}

	@Override
	public void setSlotType(String pSlotType) throws JAXRException {
		slotType = pSlotType;
	}

	@Override
	public Collection<?> getValues() throws JAXRException {
		return values;
	}

	@SuppressWarnings("rawtypes")
	@Override
	public void setValues(Collection pValues) throws JAXRException {
		values = pValues;
	}
}
