/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.infomodel;

import java.util.Collection;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;

import org.apache.labs.jaxmas.registry.accessor.ROAccessor;
import org.apache.labs.jaxmas.registry.accessor.SpecificationLinkAccessor;


/**
 * Implementtion of {@link SpecificationLink}.
 */
public class SpecificationLinkImpl extends RegistryObjectImpl<SpecificationLink> implements SpecificationLink {
    /**
     * Creates a new instance with the given registry service and key.
     */
    public SpecificationLinkImpl(RegistryServiceImpl pRegistryService, Key pKey) {
        super(pRegistryService, pKey);
    }

    @Override
    public ROAccessor<SpecificationLink> getROLoader() {
        return SpecificationLinkAccessor.getInstance();
    }

    @Override
    public ServiceBinding getServiceBinding() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public RegistryObject getSpecificationObject() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public InternationalString getUsageDescription() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Collection getUsageParameters() throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public void setSpecificationObject(RegistryObject pObj)
            throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public void setUsageDescription(InternationalString pUsageDescription)
            throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }

    @SuppressWarnings("rawtypes")
    @Override
    public void setUsageParameters(Collection pUsageParameters)
            throws JAXRException {
        throw new JAXRException(NLSStrings.OPERATION_NOT_IMPLEMENTED);
    }
}
