/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.schema;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;


/**
 * Interface of a schema updater. A schema updater is a an object, which
 * is invoked before and/or after schema updates.
 */
public interface SchemaUpdater {
	/**
	 * Called before a schema update is applied.
	 * @param pConnection The database connection to use for the schema
	 *   update. {@link Connection#setAutoCommit(boolean) AutoCommit} has been turned off
	 *   for the connection.
	 */
	void beforeUpdate(Connection pConnection, RegistryService pRegistryService) throws JAXRException, SQLException, IOException;

	/**
	 * Called after a schema update has been applied.
	 * @param pConnection The database connection to use for the schema
	 *   update. {@link Connection#setAutoCommit(boolean) AutoCommit} has been turned off
	 *   for the connection.
	 */
	void afterUpdate(Connection pConnection, RegistryService pRegistryService) throws JAXRException, SQLException, IOException;
}
