--
-- Licensed to the Apache Software Foundation (ASF) under one
-- or more contributor license agreements.  See the NOTICE file
-- distributed with this work for additional information
-- regarding copyright ownership.  The ASF licenses this file
-- to you under the Apache License, Version 2.0 (the
-- "License"); you may not use this file except in compliance
-- with the License.  You may obtain a copy of the License at
--
--  http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing,
-- software distributed under the License is distributed on an
-- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
-- KIND, either express or implied.  See the License for the
-- specific language governing permissions and limitations
-- under the License.
--


DROP TABLE RegistryEntries;
DROP TABLE Classifications;
DROP TABLE Associations;
DROP TABLE Concepts;
DROP TABLE Ids;
DROP TABLE RegistryObjectSlotValues;
DROP TABLE RegistryObjectSlots;
DROP TABLE LocalizedStrings;
DROP TABLE RegistryObjects;
DROP TABLE DbInfo;


CREATE TABLE DbInfo (
    version INT NOT NULL
);


CREATE TABLE RegistryObjects (
    roKey VARCHAR(32) NOT NULL PRIMARY KEY,
    roOwnerRestricting VARCHAR(32),
    roOwnerCascading VARCHAR(32),
    pos INT,
    roType INT NOT NULL,
    CONSTRAINT FK_RegistryObjects_OwnerCascading FOREIGN KEY (roOwnerCascading) REFERENCES RegistryObjects ON DELETE CASCADE,
    CONSTRAINT FK_RegistryObjects_OwnerRestricting FOREIGN KEY (roOwnerRestricting) REFERENCES RegistryObjects ON DELETE RESTRICT
);

CREATE TABLE LocalizedStrings (
    roKey VARCHAR(32) NOT NULL,
    lsType INT NOT NULL,
    locale VARCHAR(32) NOT NULL,
    charset VARCHAR(32) NOT NULL,
    val ${CLOB} NOT NULL,
    CONSTRAINT FK_LocalizedStrings_RO FOREIGN KEY (roKey) REFERENCES RegistryObjects ON DELETE CASCADE
);
CREATE INDEX LocalizedStrings_roKey_locale ON LocalizedStrings (roKey, locale);

CREATE TABLE RegistryObjectSlots (
    id BIGINT NOT NULL PRIMARY KEY,
    roKey VARCHAR(32) NOT NULL,
    name ${CLOB} NOT NULL,
    slotType ${CLOB},
    CONSTRAINT FK_RegistryObjectSlots_RO FOREIGN KEY (roKey) REFERENCES RegistryObjects ON DELETE CASCADE
);

CREATE TABLE RegistryObjectSlotValues (
    id BIGINT NOT NULL,
    val ${CLOB} NOT NULL,
    CONSTRAINT FK_RegistryObjectSlotValues_Slot FOREIGN KEY (id) REFERENCES RegistryObjectSlots ON DELETE CASCADE
);

CREATE TABLE Ids (
    name VARCHAR(32) NOT NULL PRIMARY KEY,
    nextValue BIGINT NOT NULL
);

CREATE TABLE Concepts (
    roKey VARCHAR(32) NOT NULL PRIMARY KEY,
    value ${CLOB},
    CONSTRAINT FK_Concepts_RO FOREIGN KEY (roKey) REFERENCES RegistryObjects ON DELETE CASCADE
);

CREATE TABLE Associations (
    roKey VARCHAR(32) NOT NULL PRIMARY KEY,
    roKeyTarget VARCHAR(32) NOT NULL,
    roKeyType VARCHAR(32) NOT NULL,
    num BIGINT NOT NULL,
    CONSTRAINT FK_Associations_RO FOREIGN KEY (roKey) REFERENCES RegistryObjects ON DELETE CASCADE,
    CONSTRAINT FK_Associations_Target FOREIGN KEY (roKeyTarget) REFERENCES RegistryObjects ON DELETE RESTRICT
);

CREATE TABLE Classifications (
    roKey VARCHAR(32) NOT NULL PRIMARY KEY,
    roKeyConcept VARCHAR(32) NOT NULL,
    num BIGINT NOT NULL,
    CONSTRAINT FK_Classifications_RO FOREIGN KEY (roKey) REFERENCES RegistryObjects ON DELETE CASCADE,
    CONSTRAINT FK_Classifications_Concept FOREIGN KEY (roKeyConcept) REFERENCES RegistryObjects ON DELETE RESTRICT
);

CREATE TABLE RegistryEntries (
    roKey VARCHAR(32) NOT NULL PRIMARY KEY,
    customType VARCHAR(32),
    expiration TIMESTAMP,
    status INT NOT NULL,
    stability INT NOT NULL,
    majorVersion INT NOT NULL,
    minorVersion INT NOT NULL,
    userVersion VARCHAR(255),
    CONSTRAINT FK_RegistryEntries_RO FOREIGN KEY (roKey) REFERENCES RegistryObjects ON DELETE CASCADE,
    CONSTRAINT FK_ObjectType FOREIGN KEY (customType) REFERENCES Concepts
);

INSERT INTO Ids (name, nextValue) VALUES ('keys', 8000);
INSERT INTO Ids (name, nextValue) VALUES ('Slots', 0);

&{macro, Taxonomy,
    'INSERT INTO RegistryObjects (roKey, pos, roType) VALUES (\1, \0, 7)',
    'INSERT INTO RegistryEntries (roKey, majorVersion, minorVersion, userVersion, status, stability) VALUES (\1, 1, 0, \'1.0\', 0, 0)',
    'INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES (\1, 0, \'en\', \'UTF-8\', \2)',
    'INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES (\1, 1, \'en\', \'UTF-8\', \3)'
}

&{Taxonomy, 0, '00000000000000000000000000000001', 'ObjectType', 'The taxonomy of object types. Object types are categories below this taxonomy.'}
&{Taxonomy, 1, '00000000000000000000000000000002', 'AssociationType', 'The taxonomy of association types. Association types are categories below this taxonomy.'}
&{Taxonomy, 2, '00000000000000000000000000000033', 'MetaModel', 'The taxonomy of concepts, which are used to store the registries meta model.'}

&{macro, Concept,
    'INSERT INTO RegistryObjects (roKey, roOwnerRestricting, pos, roType) VALUES (\1, \2, \0, 10)',
    'INSERT INTO Concepts (roKey, value) VALUES (\1, \3)',
    'INSERT INTO LocalizedStrings (roKey, lsType, locale, charset, val) VALUES (\1, 0, \'en\', \'UTF-8\', \3)'
}

&{Concept, 0, '00000000000000000000000000000003', '00000000000000000000000000000001', 'Association'}
&{Concept, 1, '00000000000000000000000000000004', '00000000000000000000000000000001', 'AuditableEvent'}
&{Concept, 2, '00000000000000000000000000000005', '00000000000000000000000000000001', 'Classification'}
&{Concept, 3, '00000000000000000000000000000006', '00000000000000000000000000000001', 'ExternalIdentifier'}
&{Concept, 4, '00000000000000000000000000000007', '00000000000000000000000000000001', 'ExternalLink'}
&{Concept, 5, '00000000000000000000000000000008', '00000000000000000000000000000001', 'Package'}
&{Concept, 6, '00000000000000000000000000000009', '00000000000000000000000000000001', 'RegistryEntry'}
&{Concept, 7, '00000000000000000000000000000010', '00000000000000000000000000000001', 'Service'}
&{Concept, 8, '00000000000000000000000000000011', '00000000000000000000000000000001', 'Taxonomy'}
&{Concept, 9, '00000000000000000000000000000012', '00000000000000000000000000000001', 'User'}
&{Concept, 10, '00000000000000000000000000000013', '00000000000000000000000000000001', 'WSDL'}
&{Concept, 11, '00000000000000000000000000000014', '00000000000000000000000000000001', 'WSPolicy'}
&{Concept, 12, '00000000000000000000000000000015', '00000000000000000000000000000001', 'Organization'}
&{Concept, 13, '00000000000000000000000000000016', '00000000000000000000000000000001', 'Category'}
&{Concept, 14, '00000000000000000000000000000017', '00000000000000000000000000000001', 'ServiceBinding'}
&{Concept, 15, '00000000000000000000000000000018', '00000000000000000000000000000001', 'SpecificationLink'}
&{Concept, 16, '00000000000000000000000000000019', '00000000000000000000000000000001', 'RegistryPackage'}
&{Concept, 17, '00000000000000000000000000000020', '00000000000000000000000000000001', 'ExtrinsicObject'}

&{Concept, 0, '00000000000000000000000000000021', '00000000000000000000000000000002', 'BelongsTo'}
&{Concept, 1, '00000000000000000000000000000022', '00000000000000000000000000000002', 'Contains'}
&{Concept, 2, '00000000000000000000000000000023', '00000000000000000000000000000002', 'EquivalentTo'}
&{Concept, 3, '00000000000000000000000000000024', '00000000000000000000000000000002', 'Extends'}
&{Concept, 4, '00000000000000000000000000000025', '00000000000000000000000000000002', 'HasChild'}
&{Concept, 5, '00000000000000000000000000000026', '00000000000000000000000000000002', 'HasParent'}
&{Concept, 6, '00000000000000000000000000000027', '00000000000000000000000000000002', 'Implements'}
&{Concept, 7, '00000000000000000000000000000028', '00000000000000000000000000000002', 'InstanceOf'}
&{Concept, 8, '00000000000000000000000000000029', '00000000000000000000000000000002', 'IsCompositionOf'}
&{Concept, 9, '00000000000000000000000000000030', '00000000000000000000000000000002', 'Replaces'}
&{Concept, 10, '00000000000000000000000000000031', '00000000000000000000000000000002', 'RelatedTo'}
&{Concept, 11, '00000000000000000000000000000032', '00000000000000000000000000000002', 'Supersedes'}
&{Concept, 12, '00000000000000000000000000000051', '00000000000000000000000000000002', 'EmployeeOf'}

&{Concept, 0, '00000000000000000000000000000034', '00000000000000000000000000000033', 'AttributeTypes'}
&{Concept, 0, '00000000000000000000000000000035', '00000000000000000000000000000034', 'string'}
&{Concept, 0, '00000000000000000000000000000036', '00000000000000000000000000000034', 'bool'}
&{Concept, 0, '00000000000000000000000000000037', '00000000000000000000000000000034', 'integer'}
&{Concept, 0, '00000000000000000000000000000038', '00000000000000000000000000000034', 'longInteger'}
&{Concept, 0, '00000000000000000000000000000039', '00000000000000000000000000000034', 'duration'}
&{Concept, 0, '00000000000000000000000000000040', '00000000000000000000000000000034', 'dateTime'}
&{Concept, 0, '00000000000000000000000000000041', '00000000000000000000000000000034', 'date'}
&{Concept, 0, '00000000000000000000000000000042', '00000000000000000000000000000034', 'number'}
&{Concept, 0, '00000000000000000000000000000043', '00000000000000000000000000000034', 'time'}
&{Concept, 0, '00000000000000000000000000000044', '00000000000000000000000000000034', 'ipv4Address'}
&{Concept, 0, '00000000000000000000000000000045', '00000000000000000000000000000034', 'ipv6Address'}
&{Concept, 0, '00000000000000000000000000000046', '00000000000000000000000000000034', 'emailAddress'}
&{Concept, 0, '00000000000000000000000000000047', '00000000000000000000000000000034', 'relation'}
&{Concept, 0, '00000000000000000000000000000048', '00000000000000000000000000000034', 'uri'}
&{Concept, 0, '00000000000000000000000000000049', '00000000000000000000000000000034', 'classification'}
&{Concept, 0, '00000000000000000000000000000050', '00000000000000000000000000000034', 'file'}


INSERT INTO DbInfo (version) VALUES (1);
