package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import java.util.List;

import javax.xml.registry.JAXRException;


/**
 * An "ORDER BY" predicate, which requests ordering by the
 * associations number.
 */
public class AssociationNumOrderPredicate implements OrderPredicate {
	private static final AssociationNumOrderPredicate theInstance = new AssociationNumOrderPredicate();

	/**
	 * Returns the singleton instance.
	 */
	public static AssociationNumOrderPredicate getInstance() {
		return theInstance;
	}
	/**
	 * Private constructor, to ensure singleton pattern.
	 */
	private AssociationNumOrderPredicate() {
		// Does nothing
	}

	@Override
	public void add(StringBuilder pBuffer, List<Object> pParameters)
			throws SQLException, JAXRException {
		pBuffer.append("assoc.num"); //$NON-NLS-1$
	}
}
