/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.labs.jaxmas.registry.sql;

import java.sql.SQLException;
import java.util.List;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;


/**
 * A predicate for searching associations by target.
 */
public class AssociationTargetPredicate implements FilterPredicate {
    private final Object key;

    /**
     * Creates a new instance with the target key.
     */
    public AssociationTargetPredicate(Key pKey) {
        assert(pKey != null);
        key = pKey;
    }

    /**
     * Creates a new instance with the target key.
     */
    public AssociationTargetPredicate(String pKey) {
        assert(pKey != null);
        key = pKey;
    }

    @Override
    public void add(StringBuilder pBuffer, List<Object> pParameters) throws SQLException, JAXRException {
        pBuffer.append("assoc.roKeyTarget=?"); //$NON-NLS-1$
        pParameters.add(key);
    }
}
